 <?php
/**********************************************************
 Controller Name : Common Function Class
 Developer Name : Prabhat Kumar Tiwari

***********************************************************/
class CommonFunction{
    
 public $db_conn;
 public $db_connAPI;

	public function __construct(){
		$dbo = new Database();
		$this->db_conn = $dbo->getConnection(); 	
		$this->db_connAPI = $dbo->getConnectionAPI(); 
	}
	
## Get Service List From Service Master
 function getServiceList(){
    $serviceList = array();
 	$sql = "SELECT service_name, service_key FROM `service_master`";
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetchAll(PDO::FETCH_ASSOC);
	if(empty($row)){
	      $rows = 0;
		}else{
foreach($row as $sRes){
	$serviceList[$sRes['service_key']] = $sRes['service_name'];	
	}
   }
   return $serviceList; 
	}
 	
 }


 # Get all operators of api list
function apiBoxOpertatorList($is_service_under_bbps=1, $service_type="ELECTRICITY"){
	$serviceList = array();

    if($is_service_under_bbps==1){
    	$is_bbps_enabled = "Yes";
    }else{
    	$is_bbps_enabled = "No";
    }

    $sql = "SELECT id, service_name AS operator_name, service_key AS operator_code FROM `apibox_service_list`  WHERE is_bbps_enabled = '".$is_bbps_enabled."' AND  service_type = '".$service_type."' ";
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetchAll(PDO::FETCH_ASSOC);
	if(empty($row)){
	      $rows = 0;
		}else{
		  $rows = $row;
		}

    return $rows; 
	}
}


# Get state code by state name
function getStateNameByStateCode($state_code){
  $sql = "SELECT state_name FROM states  WHERE state_code = '{$state_code}'";
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetch(PDO::FETCH_ASSOC);
	if(!$row){
	      $rows = 0;
		}else{
		  $rows = $row;
		}

    return $rows; 
	}
}

 # Get all operators of api list
function apiBoxOpertatorListByState($is_service_under_bbps=1, $service_type="ELECTRICITY", $state_code){
	$likeCond = "";
	if($state_code !=''){
	 $state = $this->getStateNameByStateCode($state_code);
	 $state_name = $state['state_name'];
	 $likeCond = " AND state_name LIKE '%{$state_name}%'";
	}
	
	//print_r($state); die;
	
	$serviceList = array();
    if($is_service_under_bbps==1){
    	$is_bbps_enabled = "Yes";
    }else{
    	$is_bbps_enabled = "No";
    }

    $sql = "SELECT id, service_name AS operator_name, service_key AS operator_code FROM `apibox_service`  WHERE is_bbps_enabled = '".$is_bbps_enabled."' AND  service_type = '".$service_type."' ".$likeCond;
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetchAll(PDO::FETCH_ASSOC);
	if(empty($row)){
	      $rows = 0;
		}else{
		  $rows = $row;
		}

    return $rows; 
	}
}

# Check user is applicable for using the apibox providers
function check_api_box_user($user_id){
$sql = "SELECT * FROM user_api_credentials WHERE admin_id={$user_id}"; 
 $prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetch(PDO::FETCH_ASSOC);
	if(!$row){
	      $rows = 0;
		}else{
		  $rows = $row;
		}

    return $rows; 
	}
}

# Get Additional param for selected service

function getAdditionalParam($service_key){

   $sql = "SELECT id, service_key, parameter_name, value FROM `api_box_additional_for_services`  WHERE service_key = '".$service_key."' ";
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetch(PDO::FETCH_ASSOC);
	if(!$row){
	      $rows = 0;
		}else{
		  $rows = $row;
		}

    return $rows; 
	}


}

# Get Additional param for all

function getAdditionaParamAll(){
   $services = array();	
   $sql = " SELECT id, service_key, parameter_name, value FROM `api_box_additional_for_services` ";
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetchAll(PDO::FETCH_ASSOC);
	if(!$row){
	      $service = 0;
		}else{
		  	$rows = $row;
			foreach($rows as $r){	
			$services[$r['service_key']]=$r['value'];	
			}
			$service = $services;
		}

    return $service; 
	}


}


function apibox_bill_fetch_curl($url, $postdata, $method,$token) {	
 $curl = curl_init();
 curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://www.apibox.xyz/api/Fetch/Bill?outlet_id='.$postdata['outlet_id'].'&token='.$postdata['api_token'].'&p1=dueamt&p2='.$postdata['consumer_number'].'&skey='.$postdata['operator_value'].'&reqid='.$postdata['agent_id'].'&p18='.$postdata['mode'].'&p19='.$postdata['agent_mobile'].'&p20='.$postdata['latlng'].'&p21='.$postdata['postal_code'].'&p25='.$postdata['customer_mobile'],
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    "Content-Type: application/json"
  ),
));

$response = curl_exec($curl);
curl_close($curl);
return $response;
}


# Get state list

function getStateList(){

$sql = "SELECT state_code, state_name FROM states ";
$prep_state = $this->db_conn->prepare($sql);
$prep_state->execute();
if($prep_state->errorInfo()[0]!=0){
echo "Error: " .$prep_state->errorInfo()[2];
} else {
$row = $prep_state->fetchAll(PDO::FETCH_ASSOC);
if(!$row){
  $rows = 0;
}else{
  $rows = $row;
}

return $rows; 
}
}

# Get district list by state

function getCityListByStateCode($state_code){

$sql = "SELECT district_code, district_name FROM districts WHERE state_code = '{$state_code}' ";
$prep_state = $this->db_conn->prepare($sql);
$prep_state->execute();
if($prep_state->errorInfo()[0]!=0){
echo "Error: " .$prep_state->errorInfo()[2];
} else {
$row = $prep_state->fetchAll(PDO::FETCH_ASSOC);
if(!$row){
  $rows = 0;
}else{
  $rows = $row;
}

return $rows; 
}
}



# Get state code by state name
function getStateCodeByStateName($state_code, $district_name){
    echo $sql = "SELECT state_code FROM states  WHERE state_name LIKE '%{$state_name}%'"; die;
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetch(PDO::FETCH_ASSOC);
	if(!$row){
	      $rows = 0;
		}else{
		  $rows = $row;
		}

    return $rows; 
	}
}


# Get state code by state name
function getCodeByStateName($state_name){
  $sql = "SELECT district_code FROM districts  WHERE state_code={$state_code} AND state_name LIKE %{state_name}%";
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetch(PDO::FETCH_ASSOC);
	if(!$row){
	      $rows = 0;
		}else{
		  $rows = $row;
		}

    return $rows; 
	}
}


# Get provider list

function getProviderList(){
 $sql = "SELECT id, name, key FROM providers WHERE status=1";
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetch(PDO::FETCH_ASSOC);
	if(!$row){
	      $rows = 0;
		}else{
		  $rows = $row;
		}

    return $rows; 
	}	
}


# Get API User Id 


function getApiUserId($admin_id, $forUpdate = ''){

$sql = "SELECT api_user_id FROM admin where id = '".$admin_id."' ". $forUpdate;
$stmt = $this->db_conn->prepare($sql);
$stmt->execute();			
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
return false;
} else {

$row = $stmt->fetch(PDO::FETCH_ASSOC);
return ($row['api_user_id']>0) ? $row['api_user_id'] : '0.00';
}

}


function getSuperUserId($api_user_id, $forUpdate = ''){

$sql = "SELECT partner_id  FROM api_user where id = '".$api_user_id."' ". $forUpdate;
$stmt = $this->db_conn->prepare($sql);
$stmt->execute();			
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
return false;
} else {

$row = $stmt->fetch(PDO::FETCH_ASSOC);
return ($row['partner_id']>0) ? $row['partner_id'] : '0.00';
}

}




# Get API user wallet balance

function get_api_user_balance($retailer_id, $forUpdate = '')
{

$sql = "SELECT wallet_balance FROM `add_cust` where id = '".$retailer_id."' ". $forUpdate; 
$stmt = $this->db_connAPI->prepare($sql);
$stmt->execute();			
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
return false;

} else {
$row = $stmt->fetch(PDO::FETCH_ASSOC);
return ($row['wallet_balance']>0) ? $row['wallet_balance'] : '0.00';
}

}

# Add amount into  API user wallet balance
function add_api_user_balance($retailer_id, $amount)
{
  
   $sql = "UPDATE add_cust SET `wallet_balance` = (wallet_balance + {$amount}) WHERE `id`='" . $retailer_id . "' ";
   $stmt = $this->db_connAPI->prepare($sql);
   $stmt->execute(); 

  if($stmt->errorInfo()[0]!=0){
  echo "Error: " .$stmt->errorInfo()[2];
  return false;

  } else {

  return true;
  }
  
}

# Deduct amount from  API user wallet balance

function deduct_api_user_balance($retailer_id, $amount)
{
    
  $sql = "UPDATE add_cust SET `wallet_balance` = (wallet_balance - '$amount') WHERE `id`='" . $retailer_id . "' ";
  $stmt = $this->db_connAPI->prepare($sql);
  $stmt->execute(); 

  if($stmt->errorInfo()[0]!=0){
  echo "Error: " .$stmt->errorInfo()[2];
  return false;
    } else { 
  
    return true;
  }
  
  }


function getStatusCodeList($keys=''){
$condition = "";
if($keys != '')	{
	$condition = " WHERE status_key IN ({$keys})";
}
$sql = "SELECT status_key, status_value FROM status_code";
 
$stmt = $this->db_conn->prepare($sql.$condition);  
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
} else {
$row = $stmt->fetchAll(PDO::FETCH_ASSOC);
if(!$row){
  $rows = 0;
}else{
  $rows = $row;
}

return $rows; 
}

}


# Get status name by status code

function getStatusValueByKey($staus_key){
$sql = "SELECT status_key, status_value FROM status_code WHERE status_key = {$staus_key}";
 
$stmt = $this->db_conn->prepare($sql);  
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
} else {
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$row){
  $rows = 0;
}else{
  $rows = $row['status_value'];
}
return $rows; 
}

}


# Get status value with badge

function getStatusValueWithBadgesByKey($status_key){

$sql = "SELECT status_key, status_value, badge FROM status_code WHERE status_key = {$status_key}";
 
$stmt = $this->db_conn->prepare($sql);  
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
} else {
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$row){
  $rows = 0;
}else{
  $rows = $row;
}
return $rows; 

}
}

# Covert Date from YYYY-MM-DD to DD-MM-YYYY
function convertDateToDDMMYY($date){
$newDate = date("d-m-Y H:i:s", strtotime($date));
return $newDate;
}

# Covert Date from DD-MM-YYYY to YYYY-MM-DD
function convertDateToYYMMDD($date){
$newDate = date("Y-m-d H:i:s", strtotime($date));
return $newDate;
}


function getBillTypeList(){
$sql = "SELECT id, slug, name FROM billpayment_type WHERE is_active = 1";
$stmt = $this->db_conn->prepare($sql);  
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
} else {
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$row){
  $rows = 0;
}else{
  $rows = $row;
}
return $rows; 

}


}

# Get API user wallet balance
function get_super_user_balance($super_user_id, $forUpdate = '')
{

$sql = "SELECT partner_wallet FROM `api_user` where id = '".$super_user_id."' ". $forUpdate; 
$stmt = $this->db_conn->prepare($sql);
$stmt->execute();			
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
return false;

} else {
$row = $stmt->fetch(PDO::FETCH_ASSOC);
return ($row['partner_wallet']>0) ? $row['partner_wallet'] : '0.00';
}

}

# Add amount into  API user wallet balance
function add_super_user_balance($super_user_id, $amount)
{
   $sql = "UPDATE api_user SET `partner_wallet` = (partner_wallet + {$amount}) WHERE `id`='" . $super_user_id . "' ";
   $stmt = $this->db_conn->prepare($sql);
   $stmt->execute(); 

  if($stmt->errorInfo()[0]!=0){
  echo "Error: " .$stmt->errorInfo()[2];
  return false;

  } else {

  return true;
  }
  
}

# Deduct amount from  API user wallet balance

function deduct_super_user_balance($super_user_id, $amount)
{
    
  $sql = "UPDATE api_user SET `partner_wallet` = (partner_wallet - '$amount') WHERE `id`='" . $super_user_id . "' ";
  $stmt = $this->db_conn->prepare($sql);
  $stmt->execute(); 

  if($stmt->errorInfo()[0]!=0){
  echo "Error: " .$stmt->errorInfo()[2];
  return false;
    } else { 
  
    return true;
  }
  
  }


function getDisputeByAgentTransactionId($agent_txn_id, $forupdate=''){
$sql = "SELECT * FROM `disputes` where transaction_id = '".$agent_txn_id."' ". $forUpdate;
$stmt = $this->db_conn->prepare($sql);
$stmt->execute();			
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
return false;

} else {
$row = $stmt->fetch(PDO::FETCH_ASSOC);
return $row;
}	
}



function getWlServices($wl_id){

$sql = "SELECT service_access FROM `add_cust` where id = '".$wl_id."' AND usertype='WL' ";
$stmt = $this->db_conn->prepare($sql);
$stmt->execute();			
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
return false;

} else {
$row = $stmt->fetch(PDO::FETCH_ASSOC);
return $row;
}	
}


// Get Commission Distributor Values

function getComissionForInsurance(){
 $sql = " SELECT * FROM insurance_commissions WHERE 1";
$stmt=$this->db_conn->prepare($sql);
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
  echo "Error: ".$stmt->errorInfo()[2];
}else{
 $row = $stmt->fetchAll(PDO::FETCH_ASSOC);
 if(!$row){
  $rows = 0;
 }else{
  $rows = $row;
 }  

 return $rows;
}

}

/*IRCTC function */

function getRequestDetail($user_id){
$sql = " SELECT * FROM irctc_user_boarding WHERE user_id={$user_id} AND is_requested=1";
$stmt=$this->db_conn->prepare($sql);
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
  echo "Error: ".$stmt->errorInfo()[2];
}else{
 $row = $stmt->fetch(PDO::FETCH_ASSOC);
 if(!$row){
  $rows = 0;
 }else{
  $rows = $row;
 }  

 return $rows;
}

}


function getApiUserInfo($api_user_id, $forUpdate=""){

$sql = "SELECT * FROM `add_cust` where id = '".$api_user_id."' ". $forUpdate; 
$stmt = $this->db_connAPI->prepare($sql);
$stmt->execute();			
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
return false;

} else {
$row = $stmt->fetch(PDO::FETCH_ASSOC);
return $row;
}
}


function checkIsMasterDistributor($user_id){
$sql = "SELECT user_id FROM add_distributer WHERE is_master_distributor = 1  AND user_id='".$user_id."'";
$stmt = $this->db_conn->prepare($sql);
$stmt->execute();			
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
return false;
} else {
$row = $stmt->fetch(PDO::FETCH_ASSOC);
return $row['user_id']!= 0 ? 1 : 0 ;
}
}

function getDistributorIdByMdId($user_id){	
$distIds = array();	
$sql = "SELECT id FROM add_cust WHERE creator_id='".$user_id."'";
$stmt = $this->db_conn->prepare($sql);
$stmt->execute();			
if($stmt->errorInfo()[0]!=0){
echo "Error: " .$stmt->errorInfo()[2];
return false;

} else {
$row = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach($row as $_row)
$distIds[] = $_row['id'];  	
$distIds = implode(",", $distIds );
$distIds =  rtrim($distIds, ",");
}	
return $distIds;
}


// call Location api response data

function getAreaDistrictStateByPinCode($pin_code){

$url = "https://api.postalpincode.in/pincode/".$pin_code;
 $curl = curl_init();

  curl_setopt_array($curl, array(
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
));

$response = curl_exec($curl);
curl_close($curl);
  return $response;
}

function getSavedApiResponseByPincode($pin_code){
$sql = " SELECT * FROM location_api_responses  WHERE pin_code='".$pin_code."'";
$stmt=$this->db_conn->prepare($sql);
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
  echo "Error: ".$stmt->errorInfo()[2];
}else{
 $row = $stmt->fetch(PDO::FETCH_ASSOC);
 if(!$row){
  $rows = 0;
 }else{
  $rows = $row;
 }  

 return $rows;
}	
}

function getSubloanTypeBYId($id){
$sql = " SELECT * FROM categories WHERE id='".$id."'";
$stmt=$this->db_conn->prepare($sql);
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
  echo "Error: ".$stmt->errorInfo()[2];
}else{
 $row = $stmt->fetch(PDO::FETCH_ASSOC);
 if(!$row){
  $rows = 0;
 }else{
  $rows = $row;
 }  

 return $rows['name'];
}

}


/* Send Push notification for both android and ios*/
public function sendNotification(array $udid, array $message, array $data, $deviceType){
$url = 'https://fcm.googleapis.com/fcm/send';
$arrayToSend = array();
/*notification payload*/
if($deviceType=="iOS" || $deviceType=="ios" ){
 $arrayToSend = array('registration_ids'=>$udid
,'notification' =>$message, 'priority'=>'high');
}elseif($deviceType=="android"){
$arrayToSend = array('registration_ids'=>$udid
,'notification' =>$message, 'data'=>$data, 'priority'=>'high');
}
$json = json_encode($arrayToSend); 
$headers = array();
$headers[] = 'Content-Type: application/json';        
$headers[] = 'Authorization: key= AAAAPpKMZtU:APA91bH6jzX_97c6AnzLyevpeGjc2u0w1lsMopxoGlMwhZiz5QMffnC0FbgAh_K2MeD-X_hbGMJ5IoX2fjP2OJZYLeNA2Kt1b_SW4ljKeP4OwtJMKjqGFprVr5mMz7Zdr1lWnOqMkQjb';
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
curl_setopt($ch, CURLOPT_HTTPHEADER,$headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$result = curl_exec($ch);
curl_close($ch);
return 1;
}


public function checkServiceAvailable(array $data){
	if(in_array($data['loanType'],[4,5])){
		return 1;
	}
$sql ="SELECT cbwp.* FROM `loantypecompanies` AS ltc LEFT JOIN company_branches_with_pincode AS cbwp ON (ltc.company_id=cbwp.company_id) WHERE ltc.loan_id='".$data['loanType']."' AND cbwp.block_name='".$data['block_name']."'"; 

$stmt=$this->db_conn->prepare($sql);
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
  echo "Error: ".$stmt->errorInfo()[2];
}else{
 $row = $stmt->fetchAll(PDO::FETCH_ASSOC);
 if(!$row){
  $rows = 0;
 }else{
  $rows = 1;
 }  
 return $rows;
}

}


function getSubloanTypeBYLoanType($id){
$sql = " SELECT id,name FROM categories WHERE parent_id='".$id."'";
$stmt=$this->db_conn->prepare($sql);
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
  echo "Error: ".$stmt->errorInfo()[2];
}else{
 $row = $stmt->fetchAll(PDO::FETCH_ASSOC);
 if(!$row){
  $rows = 0;
 }else{
  $rows = $row;
 }  

 return $rows;
}

}


}

?>