<?php
/**********************************************************
 Controller Name : Common Functions Class
 Developer Name : Sumit Kumar

***********************************************************/

class Common{

	
	public $db_conn;
    public $db_connAPI;

	public function __construct(){
		$dbo = new Database();
		$this->db_conn = $dbo->getConnection(); 	
		$this->db_connAPI = $dbo->getConnectionAPI(); 
	}
    	
    # Get state list
    
    function getStateList(){
    
        $sql = "SELECT state_code, state_name FROM states ";
        $prep_state = $this->db_conn->prepare($sql);
        $prep_state->execute();
        if($prep_state->errorInfo()[0]!=0){
        echo "Error: " .$prep_state->errorInfo()[2];
        } else {
        $row = $prep_state->fetchAll(PDO::FETCH_ASSOC);
        if(!$row){
          $rows = 0;
        }else{
          $rows = $row;
        }
        
        return $rows; 
        }
    }

    function getStateNameByStateCode($state_code){
        
      $sql = "SELECT state_name FROM states  WHERE state_code = '{$state_code}'";
    	$prep_state = $this->db_conn->prepare($sql);
    	$prep_state->execute();
    	if($prep_state->errorInfo()[0]!=0){
    	echo "Error: " .$prep_state->errorInfo()[2];
    	} else {
    	$row = $prep_state->fetch(PDO::FETCH_ASSOC);
    	if(!$row){
    	      $rows = 0;
    		}else{
    		  $rows = $row;
    		}
    
        return $rows; 
    	}
    }
    
	function getStateCodeByStateName($state_name){
        
      $sql = "SELECT state_code FROM states  WHERE state_name = '{$state_name}'";
    	$prep_state = $this->db_conn->prepare($sql);
    	$prep_state->execute();
    	if($prep_state->errorInfo()[0]!=0){
    	echo "Error: " .$prep_state->errorInfo()[2];
    	} else {
    	$row = $prep_state->fetch(PDO::FETCH_ASSOC);
    	if(!$row){
    	      $rows = 0;
    		}else{
    		  $rows = $row;
    		}
    
        return $rows; 
    	}
    }
	
	
	function getCityCodeByCityName($state_code,$district_name){
        
      $sql = "SELECT district_code FROM districts  WHERE state_code = '{$state_code}' AND district_name = '{$district_name}'";
    	$prep_dist = $this->db_conn->prepare($sql);
    	$prep_dist->execute();
    	if($prep_dist->errorInfo()[0]!=0){
    	echo "Error: " .$prep_dist->errorInfo()[2];
    	} else {
    	$row = $prep_dist->fetch(PDO::FETCH_ASSOC);
    	if(!$row){
    	      $rows = 0;
    		}else{
    		  $rows = $row;
    		}
    
        return $rows; 
    	}
    }
	
    function getCityNameByCityCode($state_code,$city_code){
        
      $sql = "SELECT district_name FROM districts  WHERE state_code = '{$state_code}' AND district_code = '{$city_code}'";
    	$prep_dist = $this->db_conn->prepare($sql);
    	$prep_dist->execute();
    	if($prep_dist->errorInfo()[0]!=0){
    	echo "Error: " .$prep_dist->errorInfo()[2];
    	} else {
    	$row = $prep_dist->fetch(PDO::FETCH_ASSOC);
    	if(!$row){
    	      $rows = 0;
    		}else{
    		  $rows = $row;
    		}
    
        return $rows; 
    	}
    }


    function getShopList(){
    
        $sql = "SELECT shop_category,shop_description FROM shopcategory ";
        $prep_shop = $this->db_conn->prepare($sql);
        $prep_shop->execute();
        if($prep_shop->errorInfo()[0]!=0){
        echo "Error: " .$prep_shop->errorInfo()[2];
        } else {
        $row = $prep_shop->fetchAll(PDO::FETCH_ASSOC);
        if(!$row){
          $rows = 0;
        }else{
          $rows = $row;
        }
        
        return $rows; 
        }
    }



    function getStateNameByStateID($state_id){
    
      $sql = "SELECT state_name FROM all_states  WHERE id = '{$state_id}'";
    	$prep_state = $this->db_conn->prepare($sql);
    	$prep_state->execute();
    	if($prep_state->errorInfo()[0]!=0){
    	echo "Error: " .$prep_state->errorInfo()[2];
    	} else {
    	$row = $prep_state->fetch(PDO::FETCH_ASSOC);
    	if(!$row){
    	      $rows = 0;
    		}else{
    		  $rows = $row;
    		}
    
        return $rows; 
    	}
    }

    function getCityNameByCityID($city_id){
    	
      $sql = "SELECT city_name FROM all_cities  WHERE id = '{$city_id}'";
    	$prep_city = $this->db_conn->prepare($sql);
    	$prep_city->execute();
    	if($prep_city->errorInfo()[0]!=0){
    	echo "Error: " .$prep_city->errorInfo()[2];
    	} else {
    	$row = $prep_city->fetch(PDO::FETCH_ASSOC);
    	if(!$row){
    	      $rows = 0;
    		}else{
    		  $rows = $row;
    		}
    
        return $rows; 
    	}
    }
    
    
    function validate_dob($dob)
	{
		$str_dob = strtotime($dob);

		$min = strtotime('+18 years', $str_dob);

		if(time() < $min)  
		{
			$response = array(
							"type" => "error",
							"message" => "Enter valid 18 + age"
						);
		}else
		{
			$response = array(
							"type" => "success",
							"message" => ""
						);
		}

		return $response;
	}

	function validate_gst($gst)
	{
		if($gst != '')  
		{
			if(!preg_match('/[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[1-9A-Z]{1}Z[0-9A-Z]{1}/',$gst)) 
			{
				$response = array(
							"type" => "error",
							"message" => "Enter valid 18 + age"
						);
			}else
			{
				$response = array(
							"type" => "success",
							"message" => ""
						);
			}

		}else
		{
			$response = array(
							"type" => "success",
							"message" => ""
						);
		}

		return $response;
	}
	
	
    	function upload_curl($url, $data) { 
    			$curl = curl_init();
    			curl_setopt_array($curl, array(
    			  CURLOPT_URL => $url,
    			  CURLOPT_RETURNTRANSFER => true,
    			  CURLOPT_ENCODING => "",
    			  CURLOPT_MAXREDIRS => 10,
    			  CURLOPT_TIMEOUT => 120,
    			  CURLOPT_FOLLOWLOCATION => true,
    			  CURLOPT_CUSTOMREQUEST => "POST",
    			  CURLOPT_POSTFIELDS => $data,
    			  CURLOPT_HTTPHEADER => array('content-type: multipart/form-data'),
    			));
    			$response = curl_exec($curl);
    			$err = curl_error($curl);
    			curl_close($curl);
    			if ($err) {
    				echo "cURL Error #:" . $err;
    			} else {
    				return $response;
    			}
    	}
    	
    	
    	function getCityListByStateCode($state_code)
    	{

            $sql = "SELECT district_code, district_name FROM districts WHERE state_code = '{$state_code}' ";
            $prep_state = $this->db_conn->prepare($sql);
            $prep_state->execute();
            if($prep_state->errorInfo()[0]!=0){
            echo "Error: " .$prep_state->errorInfo()[2];
            } else {
            $row = $prep_state->fetchAll(PDO::FETCH_ASSOC);
            if(!$row){
              $rows = 0;
            }else{
              $rows = $row;
            }

            return $rows; 
            }
        }
        
        
        function check_special_details($data,$num)
        {
            $arr = array();

            foreach($data as $key => $val)
            {
                if($num)
                {
                    if(preg_match('/[^a-z0-9 _-]+/i', $val))
                    {
                        $arr = array(
                                        'msg' => 'This '.$key.' information '.$val.' not correct',
                                        'res' => '1' 
                                    );
                    }

                }else
                {
                    if(preg_match('/[^a-z _-]+/i', $val))
                    {
                        $arr = array(
                                        'msg' => 'This '.$key.' information '.$val.' not correct',
                                        'res' => '1' 
                                    );
                    }
                }
                
            }
            
            return $arr;
        }
	
	

        function getOperatorList($operator_type)
        {
    
            $sql = "SELECT *FROM operators WHERE type = '".$operator_type."'";
            $prep_ope = $this->db_conn->prepare($sql);
            $prep_ope->execute();
            if($prep_ope->errorInfo()[0]!=0){
            echo "Error: " .$prep_ope->errorInfo()[2];
            } else {
            $row = $prep_ope->fetchAll(PDO::FETCH_ASSOC);
            if(!$row){
              $rows = 0;
            }else{
              $rows = $row;
            }
            
            return $rows; 
            }
        }

        function getCircleList($operator_id)
        {
    
            $sql = "SELECT *FROM circle_code WHERE operator_code = '".$operator_id."'";
            $prep_ope = $this->db_conn->prepare($sql);
            $prep_ope->execute();
            if($prep_ope->errorInfo()[0]!=0){
            echo "Error: " .$prep_ope->errorInfo()[2];
            } else {
            $row = $prep_ope->fetchAll(PDO::FETCH_ASSOC);
            if(!$row){
              $rows = 0;
            }else{
              $rows = $row;
            }
            
            return $rows; 
            }
        }

        function netpaisa_curl($url) {


            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 120,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => false,
                CURLOPT_CUSTOMREQUEST => "GET",
                //CURLOPT_POSTFIELDS => $post_fields,

            ));
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
            if ($err) {
                echo "cURL Error #:" . $err;
            } else {
                return $response;
            }
        }



function getSubloanTypeBYId($id){
$sql = " SELECT * FROM categories WHERE id='".$id."'";
$stmt=$this->db_conn->prepare($sql);
$stmt->execute();
if($stmt->errorInfo()[0]!=0){
  echo "Error: ".$stmt->errorInfo()[2];
}else{
 $row = $stmt->fetch(PDO::FETCH_ASSOC);
 if(!$row){
  $rows = 0;
 }else{
  $rows = $row;
 }  

 return $rows['name'];
}

}

# Covert Date from YYYY-MM-DD to DD-MM-YYYY
function convertDateToDDMMYY($date){
$newDate = date("d-m-Y H:i:s", strtotime($date));
return $newDate;
}  
	
		 
    }

?>