<?php
	
 use PHPMailer\PHPMailer\PHPMailer;
 use PHPMailer\PHPMailer\SMTP;
 use PHPMailer\PHPMailer\Exception;	
	
 require __DIR__.'../../../vendor/autoload.php';
 
	class Mysqlquery{
		//private $db_conn;
		
		public function __construct()
		{
			$database = new Database();
			$db = $database->getConnection();
			$this->db_conn = $db;
		}
		
		// Insert row
		function insertData($table,$dataArray){			
			$fields = array_keys($dataArray);
			$fildvalu = array_values($dataArray);	
			
			$col_list = implode(",", $fields);
			$param_list = implode(",", array_fill(1,count($fields), "?"));
			
			$sql="INSERT into $table ($col_list) VALUES ($param_list)";
			$stmt = $this->db_conn->prepare($sql);
			
			$stmt->execute($fildvalu);
			$error= $stmt->errorInfo();

			if($error[0]!=0){
				echo "Error1: " .$error[2];
			} else {
				return $this->db_conn->lastInsertId();
			}
		}
		
		// Update row
		function updateData($table,$dataArray,$condition){
			$fields = array_keys($dataArray);
			$fildvalu = array_values($dataArray);	
			$data = "";
			foreach($fields as $feild){
				$data .= "`".$feild."`". "= ?, ";
			}
			$data = substr($data, 0, -2);
			$sql="UPDATE $table set $data $condition";
			$stmt = $this->db_conn->prepare($sql);
			
			$stmt->execute($fildvalu);
			$error = $stmt->errorInfo();

			if($error[0]!=0){
				echo "Error1: " .$error[2];
			} else {
				return $stmt->rowCount();
			}
		}
		
		//Count Total Rows
		function countRows($sql){
			$prep_state = $this->db_conn->prepare($sql);
			$prep_state->execute();
			$num = $prep_state->rowCount();
			return $num;
		}
		
		//Fetch All Row
		function fetchAllData($table,$fields,$condition){ 
			$prep_state = $this->db_conn->prepare("SELECT ".$fields." FROM ".$table." ".$condition);
			$prep_state->execute();			
			$row = $prep_state->fetchAll(PDO::FETCH_ASSOC);			
			if($prep_state->errorInfo()[0]!=0){
				echo "Error: " .$prep_state->errorInfo()[2];
			} else {
				return $row;
			}
		} 
		
		//Fetch Single Row
		function fetchRow($table,$fields,$condition){
			$prep_state = $this->db_conn->prepare("SELECT ".$fields." FROM ".$table." ".$condition);
			$prep_state->execute();			
			$row = $prep_state->fetch(PDO::FETCH_ASSOC);			
			if($prep_state->errorInfo()[0]!=0){
				echo "Error: " .$prep_state->errorInfo()[2];
			} else {
				return $row;
			}
		} 
		
		function mysqlQuery($sql){
			$prep_state = $this->db_conn->prepare($sql);
			$prep_state->execute();
			if($prep_state->errorInfo()[0]!=0){
				echo "Error: " .$prep_state->errorInfo()[2];
			} else {
				return $prep_state;
			}			
		}
		//code added on 20 august 2020
		function fetchAllDataJoin($query){ 
			$prep_state = $this->db_conn->prepare($query);
			$prep_state->execute();			
			$row = $prep_state->fetchAll(PDO::FETCH_ASSOC);			
			if($prep_state->errorInfo()[0]!=0){
				echo "Error: " .$prep_state->errorInfo()[2];
			} else {
				return $row;
			}
		} 	
		//code end for 20 august 2020
		function close_connection(){
			/* $prep_state = $this->db_conn->prepare('KILL CONNECTION_ID()');
			$prep_state->execute();	 */	
			return false;
		}
		
	function SendDynamicMessage(  $mobile,$message,$wl_id,$admin_id ){

		//$wl_id=1;$admin_id=29;

		// new dynamic otp code start

		$query = " select sms_api from add_cust where id = '".$wl_id."' ";
		$stmt = $this->db_conn->prepare($query);
		$stmt->execute();
		$resWL = $stmt->fetch(PDO::FETCH_ASSOC);
		
		if($stmt->rowCount() > 0) {

			if($resWL['sms_api']=='CUSTOM'){

				$query = " select * from `sms_pack` WHERE `user_id`='".$wl_id."' and `admin_id`='".$admin_id."' ";
				$stmt = $this->db_conn->prepare($query);
				$stmt->execute();
				$sms_pack = $stmt->fetch(PDO::FETCH_ASSOC);
				
			}
			else {

				$query = " select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='".$admin_id."' ";
				$stmt = $this->db_conn->prepare($query);
				$stmt->execute();
				$sms_pack = $stmt->fetch(PDO::FETCH_ASSOC);
				
				if(empty($sms_pack['id'])){
					
					$query = " select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='1' ";
					$stmt = $this->db_conn->prepare($query);
					$stmt->execute();
					$sms_pack = $stmt->fetch(PDO::FETCH_ASSOC);

				}
			}
			
			//print_r($sms_pack);exit;
			$smsParameters = json_decode($sms_pack['api_parameters'],true);

			$smsParameters[$sms_pack['param_mobile_name']] = $mobile;
			$smsParameters[$sms_pack['param_msg_name']] = $message;
			$smsParameters['request_type'] = $sms_pack['request_type'];
			$smsParameters['url'] = $sms_pack['url'];
			$helpers = new Helper_class();
			$sms_api_res =  $helpers->send_msg_dynamic($smsParameters);

			return $sms_api_res;
		}	

		// new dynamic otp code end
	}	
	
	function SendDynamicMessageOnEmail($ToEmail,$WLdomain,$MailTitle,$subject,$email_body){
		
		
		$domain = str_replace("https://", "", $WLdomain);
		$domain = rtrim($domain, "/");
		if(preg_match("/localhost/i", $domain)){
			$exploded = explode("/", $domain);
			$domain = end($exploded);
			$fromEmail = "info@".$domain."yopmail.com"; 		
		}else{
			$fromEmail = "info@".$domain;
		}
	  if(ENV == 'production'){
		$mail = new PHPMailer(true);
		try {
		//Server settings
		$mail->SMTPDebug = SMTP::DEBUG_SERVER;                      
		$mail->isSMTP();                                       
		$mail->Host       = MAIL_HOST;                    
		$mail->SMTPAuth   = true;                                   
		$mail->Username   = MAIL_USERNAME;                     
		$mail->Password   = MAIL_PASSWORD;                             
		$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
		$mail->Port       = MAIL_PORT; 
		$mail->SMTPDebug = false;                                   
		//Recipients
		$mail->setFrom($fromEmail, $MailTitle);		                  
		$mail->addAddress($ToEmail, '');                   
		//$mail->addReplyTo('info@digifintel.in', 'Information');
		// Content
		$mail->isHTML(true);                                  
		$mail->Subject = $subject;
		$mail->Body    = $email_body;
		//$mail->AltBody = '';
		//print_r($mail);exit;
		
			$mail->send();
			//echo "Message has been sent successfully";
			return true;
		} catch (Exception $e) {
			echo "Mailer Error: " . $mail->ErrorInfo;
			return false;
		}
		return true;
	}		
	
	function GetOtpExpTimeAndWrongAttempt(){
		$query = " SELECT wrong_attempt,otp_exp_time FROM default_setting ";
		$stmt = $this->db_conn->prepare($query);
		$stmt->execute();		
		$DefaultSetting = $stmt->fetch(PDO::FETCH_ASSOC);
		
		if( isset($DefaultSetting) ){
			$rsp['wrong_attempt'] = $DefaultSetting['wrong_attempt'];
			$rsp['otp_exp_time'] = $DefaultSetting['otp_exp_time'];
		}else{
			$rsp['wrong_attempt'] = 0;
			$rsp['otp_exp_time'] = 0;
		}
		return $rsp;
	}
	function fetchSingleRowWithJoin($sql){ 
		
		$prep_state = $this->db_conn->prepare($sql);
		$prep_state->execute();			
		$row = $prep_state->fetch(PDO::FETCH_ASSOC);
		if(!$row){
	      $rows = 0;
		}else{
		  $rows = $row;
		}			
	  return $rows;	
	}


## Get Service List From Service Master
 function getServiceList(){
    $serviceList = array();
 	$sql = "SELECT service_name, service_key FROM `service_master`";
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetchAll(PDO::FETCH_ASSOC);
	if(!$row){
	      $rows = 0;
		}else{
		  $rows = $row;
		}

	if($row !==0){
	foreach($row as $sRes){
	$serviceList[$sRes['service_key']] = $sRes['service_name'];	
	}
	}
    return $serviceList; 
	}
 	
 }


 function save($table, $data){
	
	date_default_timezone_set('Asia/Kolkata');
	$datetime=date('Y-m-d H:i:s');
	
	$query="INSERT INTO ".$table." SET ";
	foreach($data as $key=>$val){
	$query .= $key."='".$val."', ";
	}
	$query .=" created_at = '$datetime'"; 
	//echo $query; exit; 
	$stmt = $this->db_conn->prepare($query);
	$stmt->execute();
	$id = $this->db_conn->lastInsertId();
	return $id; 
  } 


 function getAssignServiceList($wl_id){
 	$serviceList = array();
 	$sql = "SELECT id, service_name, service_key, is_mpin FROM `service_mpin_settings`";
	$prep_state = $this->db_conn->prepare($sql);
	$prep_state->execute();
	if($prep_state->errorInfo()[0]!=0){
	echo "Error: " .$prep_state->errorInfo()[2];
	} else {
	$row = $prep_state->fetchAll(PDO::FETCH_ASSOC);
	if(!$row){
	      $rows = 0;
		}else{
		  $rows = $row;
		}

	
    return $rows; 
	}
 } 


function edit($table, $data, $id, $wl_id){
	
	$query="UPDATE ".$table." SET ";
	foreach($data as $key=>$val){
	$query .= $key."='".$val."', ";
	}
	
	$query .=" updated_at = NOW() WHERE id='".$id."' AND wl_id='".$wl_id."'";
	$stmt = $this->db_conn->prepare($query);
	$stmt->execute();
	$id = $wl_id;
	return $id; 
}



}
?>