<?php
  
  require("../config.php");
  require("classes/db_class.php");
  require("classes/comman_class.php");
  require("classes/user_class.php");
  require("classes/common/Common.php");
  require("classes/jwt_encode_decode.php");

  $helpers = new Helper_class();
  $commonfunction = new Common();
  $mysqlClass = new Mysql_class();
  $userClass = new User_class();
  $jwtED = new jwt_encode_decode();

function requiredInput($inputArr,$requiredFields){
	foreach($requiredFields as $v) {
	   if(!isset($inputArr[$v]) || empty($inputArr[$v])) {
		  $emptyError[] = $v;
	   }
	}
	return $emptyError;
}
  
  if($_SERVER['HTTP_X_API_KEY']==HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY']==DGFNAPASSKEY){  
  } else {
    $helpers->errorResponse("Authorization Invalid !");
  }
  
  if($_SERVER['REQUEST_METHOD']=="POST" && isset($_POST)){
    
    $post = $helpers->clearSlashes($_POST);

	$requiredFields = array('name','dob', 'email','mobile','address','landmark','state','city','pin','cname','c_address','c_landmark','c_state','c_pin','c_city','shop_category','pan_no','aadhar_no');
	$errorRequired = requiredInput($post,$requiredFields);
	if(!empty($errorRequired)) {
	  foreach($errorRequired as $eE){
		  $helpers->errorResponse("Please enter valid ". $eE);
	  }
	}

	//// Valided Token and Get Token Details ////
		if(isset($post['token'])){
			$res = $jwtED->decode_token($post['token']);
			if(isset($res->USER_ID) && $res->USER_ID > 0){
				$USER_ID 	= $res->USER_ID;
				$CREATOR_ID	= $res->CREATOR_ID;
				$WL_ID 		= $res->WL_ID;
				$ADMIN_ID 	= $res->ADMIN_ID;
				$USER_TYPE  = $res->USER_TYPE;
			} else {
				$helpers->errorResponse("Token Expire");
			}
		} else {
			$helpers->errorResponse("Token not set!");
		}
	/////////////////// End //////////////////
        
    /************* check special character start ***************/
    
    $checkname['name'] = $post['name'];
    $checkname['m_name'] = $post['m_name'];
    $checkname['l_name'] = $post['l_name'];
	    
    $check_special_name = $commonfunction->check_special_details($checkname,$num = '');
    if(isset($check_special_name['msg']) && !empty($check_special_name['msg']))
    {
        $helpers->errorResponse($check_special_name['msg']);
    }

    $checkarr['cname'] = $post['cname'];
    $checkarr['c_address'] = $post['c_address'];
    $checkarr['c_landmark'] = $post['c_landmark'];
    $checkarr['address'] = $post['address'];
    $checkarr['landmark'] = $post['landmark'];
    $checkarr['gst_no'] = $post['gst_no'];

    /*$check_special_details = $commonfunction->check_special_details($checkarr,$num = true);

    if(isset($check_special_details['msg']) && !empty($check_special_details['msg']))
    {
		$helpers->errorResponse($check_special_details['msg']);
    }*/

    
    /************* check special character end ***************/

	$dist_id = empty($post['dist_id']) ? $USER_ID : $post['dist_id'];
	$post['user_capping'] = !isset($post['user_capping']) ? 0 : $post['user_capping'];
    
    $limit = $mysqlClass->mysqlQuery("select number_of_child_limi from `add_cust` WHERE `id`='".$USER_ID."' and `admin_id`='".$ADMIN_ID."'  ")->fetch(PDO::FETCH_ASSOC);

	if(empty($limit['number_of_child_limi']) || $limit['number_of_child_limi'] <= 0){
		$helpers->errorResponse('No Limit to create user.');  
	}
	if(!empty($post['number_of_child_limi']) && $limit['number_of_child_limi'] < $post['number_of_child_limi'] + 1){
		$helpers->errorResponse('No Limit to set user capping limit.');  
	}

	if(!preg_match('/^[0-9]{10}+$/',$post['mobile']))
    {
		$helpers->errorResponse('Please enter valid mobile.'); 
	}
	if(!filter_var($post['email'], FILTER_VALIDATE_EMAIL))
    {
		$helpers->errorResponse('Please enter valid email.'); 
	}
	if(!preg_match("/^([a-zA-Z]){5}([0-9]){4}([a-zA-Z]){1}?$/", $post['pan_no']))
    {
		$helpers->errorResponse('Please enter valid pan_no.'); 
	}
	if(!preg_match('/^[0-9]{12}+$/',$post['aadhar_no']))
    {
		$helpers->errorResponse('Please enter valid aadhar_no.'); 
	}

    //// Check Admin api_access_key ////
    $apiAccessKey = $userClass->get_api_access_key($ADMIN_ID);

    if(empty($apiAccessKey['api_access_key'])){
		$helpers->errorResponse('Admin API Access Key Not Set.');  
    }
    $api_access_key = $apiAccessKey['api_access_key'];

    /////////////////// End //////////////////
	
	
	if($post['USER_SERVICE_TYPE'] != '3'){

		if((empty($post['package']) || $post['package'] < 0) && $USER_TYPE == 'WL'){
			$helpers->errorResponse('Package not selected (Package id missing!).');
		}
	}
	$countUser = $mysqlClass->countRows("select id from `add_cust` WHERE wl_id='".$WL_ID."' and (`email`='".$post['email']."' OR `mobile`='".$post['mobile']."' ) ");
	if($countUser>0){
		$helpers->errorResponse('User already exist with email or mobile');  
	}
	
		/********************* Upload KYC Document Start ********************************************************************************************************/

		if(isset($_FILES['aadhar_file']['name']) && !empty($_FILES['aadhar_file']['name'])){
			$newName1 = 'RT_'.$post['aadhar_no'].'_'.$USER_ID;
			$aadharFileUpload = $helpers->fileUpload($_FILES["aadhar_file"],"../uploads/kyc-doc/",$newName1,true);
			if($aadharFileUpload['type']=="success"){
				$aadhar_file_name = $aadharFileUpload['filename'];
			} else {
				$aadharFileUploadError = isset($aadharFileUpload['message']) ? $aadharFileUpload['message'] : 'Aadhar Upload error!';
				$helpers->errorResponse($aadharFileUploadError);
			}
		} else {
			$helpers->errorResponse('Aadhaar Image is required!');
		}
		
		if(isset($_FILES['pan_file']['name']) && !empty($_FILES['pan_file']['name'])){
			$newName2 = 'RT_'.$post['pan_no'].'_'.$USER_ID;
			$panFileUpload = $helpers->fileUpload($_FILES["pan_file"],"../uploads/kyc-doc/",$newName2,true);
			if($panFileUpload['type']=="success"){
				$pan_file_name = $panFileUpload['filename'];
			} else {
				$panFileUploadError = isset($panFileUpload['message']) ? $panFileUpload['message'] : 'Pan Upload error!';
				$helpers->errorResponse($panFileUploadError);
			}
		} else {
			$helpers->errorResponse('PAN Image is required!');
		}
		
		if(isset($_FILES['shop_img']['name']) && !empty($_FILES['shop_img']['name'])){
			$newName3 = 'RT'.$post['mobile'].'_'.$USER_ID;
			$shopFileUpload = $helpers->fileUpload($_FILES["shop_img"],"../uploads/kyc-doc/","shop_".$newName3,true);
			if($shopFileUpload['type']=="success"){
				$shop_file_name = $shopFileUpload['filename'];
			} else {
				$shopFileUploadError = isset($shopFileUpload['message']) ? $shopFileUpload['message'] : 'Shop Image Upload error!';
				$helpers->errorResponse($shopFileUploadError);
			}
		} else {
			$shop_file_name = '';
		}
		
		if(isset($_FILES['gst_file']['name']) && !empty($_FILES['gst_file']['name'])){
			$newName4 = 'RT'.$post['mobile'].'_'.$USER_ID;
			$gstFileUpload = $helpers->fileUpload($_FILES["gst_file"],"../uploads/kyc-doc/","gst_".$newName4);
			if($gstFileUpload['type']=="success"){
				$gst_file_name = $gstFileUpload['filename'];
			} else {
				$gstFileUploadError = isset($gstFileUpload['message']) ? $gstFileUpload['message'] : 'Shop Image Upload error!';
				$helpers->errorResponse($gstFileUploadError);
			}
		} else {
			$gst_file_name = '';
		}


	/********************* Upload KYC Document End ***********************************************************************************************************/

	
	
	$pass = bin2hex(random_bytes(5)); // generate random password
	$s_pin = mt_rand(1000,10000);   // generate random login pin
	$hash_pass = $helpers->hashPassword($pass);
	$spin = $helpers->hashPin($s_pin);

	$var = $post['dob'];
	$date = str_replace('/', '-', $var);
	$dob =  date('Y-m-d', strtotime($date));

	
        $packageID = isset($post['package']) ? $post['package'] : 0;
		if($packageID==0){
			if($post['USER_SERVICE_TYPE'] != '3'){
				$distPackage = $mysqlClass->fetchRow("add_cust"," package_id ", " WHERE id = '".$dist_id."' and usertype = 'DISTRIBUTOR' "); 
				$packageID = isset($distPackage['package_id']) ? $distPackage['package_id'] : 0;
			}
		}

        $name = $post['name'].' '.$post['m_name'].' '.$post['l_name'];
        $gst_no = isset($post['gst_no']) ? $post['gst_no'] : '';          
        $service_access = isset($post['service_access']) ? $post['service_access'] : '';          
        $is_master = isset($post['is_master']) ? $post['is_master'] : 0;     
		$user_service_type = isset($post['USER_SERVICE_TYPE']) ? $post['USER_SERVICE_TYPE'] : 1;      
			$value = array(              
                'name'          => $name,
                'mobile'        => $post['mobile'],
                'pass'          => $hash_pass['encrypted'],
                'security_pin'  => $spin['encrypted'],
                'master_pin'    => $spin['encrypted'],
                'email'         => $post['email'],
                'cname'         => $post['cname'],
                'state_code'    => $post['c_state'],
                'state'    		=> $post['c_state'],
                'district_code' => $post['c_city'],
                'city' 			=> $post['c_city'],
                'pin'           => $post['c_pin'],
                'aadhar_no'     => $post['aadhar_no'],
                'pan_no'        => $post['pan_no'],
                'gst_no'        => $post['gst_no'],
                'number_of_child_limi'        => $post['user_capping'],
                'service_access'       => $service_access,
                'address'       => $post['c_address'],
                'package_id'    => $packageID,
                'status'        => 'ENABLED',
                'api_access_key'=> $api_access_key,
                'usertype'      => "DISTRIBUTOR",        
                'created_on'    => date("Y-m-d H:i:s"),
                'created_by'    => $USER_TYPE,
                'creator_id'    => $dist_id,
                'wl_id'         => $WL_ID,
                'admin_id'      => $ADMIN_ID,
				'aadhar_file'   => $aadhar_file_name,
				'pan_file'      => $pan_file_name,
				'gst_file'      => $gst_file_name,
				'user_service_type'      => $user_service_type,
            );
             
            $last_id = $mysqlClass->insertData('add_cust',$value);
                    
        if($last_id>0)
        {
			$min_amt_capping = (isset($post['min_amt_capping']) && $post['min_amt_capping'] >= 0) ? $post['min_amt_capping'] : 0;
                /******* Create Login Id Start ******************/   
				
				if($ADMIN_ID == 54)
				{
				  $uId = 'CJL'.$last_id;
				  $min_amt_capping = ($min_amt_capping > 0)? $min_amt_capping : 0;                  
				}
				else
				{
					if($is_master==1){
						$uId = 'MD'.$last_id;								
					} else {
						$uId = 'DT'.$last_id;								
					}
				  $min_amt_capping = ($min_amt_capping > 0)? $min_amt_capping : 100;
				}

                $dValues = array(
                    'user' => $uId,
                    'min_amt_capping' => $min_amt_capping
                );  

                $mysqlClass->updateData(' add_cust ', $dValues, " where id = '".$last_id."' ");
                
                $dValue = array(
                      'user_id'               => $last_id,
                      'status'                => 'Active',
                      'created_by'            => $USER_TYPE,
                      'creator_id'            => $USER_ID,
                      'is_master_distributor' => $is_master,
                      'package_id'            => $packageID
                    );

                $mysqlClass->insertData(' add_distributer ', $dValue);
                
                /******* Create Login Id End ******************/
                
                /*********************** customer details start ***************/

                $valid_on = date('Y-m-d H:i:s', strtotime('+ 60 days'));
				$cValue = array(
                      
					  'user_id'         => $last_id,
					  'ip'              => $_SERVER['REMOTE_ADDR'],
					  'shop_category'   => $post['shop_category'],
					  'specify_category'   => $post['otCatName'],
					  'expected_volume' => $post['expected_volume'],
					  'landmark'        => $post['landmark'],
					  'c_landmark'      => $post['c_landmark'],
					  'c_district'      => $post['city'],
					  'c_state_code'    => $post['state'],
					  'c_pin'           => $post['pin'],
					  'shop_owner'      => $post['shop_owner'],
					  'dob'             => $dob,
					  'address'         => $post['address'],
					  'shop_img'        => $shop_file_name,
					  'aadhar_mask'     => '',
					  'valid_on'        => $valid_on
				  
				  );                
                $mysqlClass->insertData(' cust_details ', $cValue);

                /*********************** customer details end ***************/

                /* Update User Child limit */
				$updateLimit = $limit['number_of_child_limi'] - (1 + $post['number_of_child_limi']);
				$mysqlClass->updateData(' add_cust ', array('number_of_child_limi'=>$updateLimit), " where id = '".$USER_ID."' ");

				$wlDetail = $mysqlClass->mysqlQuery(" select sms_api from add_cust where id = '".$WL_ID."' ");
				$resWL = $wlDetail->fetch(PDO::FETCH_ASSOC);


				$wl_domain = $mysqlClass->fetchRow("add_white_label"," domain ", " WHERE user_id = '".$WL_ID."' "); 
				$wlDomain = !empty($wl_domain['domain']) ? $wl_domain['domain'] : '';
				
				if($ADMIN_ID == 54)
				{
				  $userDetailes = "Your Registration has been successfully in ekendra please find your loign details User id: ".$uId." Password: ".$pass." Pin: ".$s_pin." Login URL:".$wlDomain;
				}
				else if($ADMIN_ID == 90)
				{
					$userDetailes = "LoginId: ".$uId." Password: ".$pass." PIN: ".$s_pin." Website: ".$wlDomain." aonepay.co.in";		  
				}
				else
				{
					$userDetailes = "Dear User, Your UserId: ".$uId.", Password: ".$pass.", Pin: ".$s_pin." for website: ".$wlDomain. " login. NETFIN";

				//   $userDetailes = "LoginId: ".$uId." Password: ".$pass." PIN: ".$s_pin." Website: ".$wlDomain;
				}

                
                if($resWL['sms_api']=='CUSTOM'){
					$sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='".$WL_ID."' and `admin_id`='".$ADMIN_ID."'" )->fetch(PDO::FETCH_ASSOC);
                } else {
					$sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='".$ADMIN_ID."'" )->fetch(PDO::FETCH_ASSOC);

                  if(empty($sms_pack['id'])){
					$sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='1'" )->fetch(PDO::FETCH_ASSOC);
                  }
                }
				
				/* code for template id */					
				if(isset($sms_pack['template_ids']) && $sms_pack['template_ids'] !="")
				{
					$smsTemplate = json_decode($sms_pack['template_ids'],true);
					$smsParameters[$sms_pack['template_key']] = $smsTemplate['reg'] ;
				}
				/* end code for template id */
				
                $smsParameters = json_decode($sms_pack['api_parameters'],true);
                $smsParameters[$sms_pack['param_mobile_name']] = $post['mobile'];
                $smsParameters[$sms_pack['param_msg_name']] = $userDetailes;
                $smsParameters['request_type'] = $sms_pack['request_type'];
                $smsParameters['url'] = $sms_pack['url'];
                $sms_api_res =  $helpers->send_msg_dynamic($smsParameters);

                $response['ERROR_CODE'] = 0;
                $response ['MESSAGE']=  $userDetailes;
                

        }
		  else
        {
			$response['ERROR_CODE'] = 1;
			$response['MESSAGE'] = 'Registration failed , Please try again';
        }

  } else {
    $response['ERROR_CODE'] = 1;
    $response['MESSAGE'] = 'Invalid request !';
  }
  echo json_encode($response);
  
  $mysqlClass->close_connection();
  die();
?>