<?php
/*************** 
ERROR_CODE -> 0 - Success / 1 - Error
MESSAGE -> ""
***************/
	require("../../config.php");
	require("../classes/db_class.php");
	require("../classes/comman_class.php");
	require("../classes/user_class.php");
	require("../classes/jwt_encode_decode.php");
	$helpers = new Helper_class();
	$mysqlClass = new Mysql_class();
	$userClass = new user_class();
	$jwtED = new jwt_encode_decode();
	
	
	if($_SERVER['HTTP_X_API_KEY']==HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY']==DGFNAPASSKEY){	
	} else {
		//print_r($_SERVER);
		$helpers->errorResponse("Authorization Invalid !");
	}
	
	if($_SERVER['REQUEST_METHOD']=="POST" && isset($_POST)){
		
		$post = $helpers->clearSlashes($_POST);
		
		//// Valided Token and Get Token Details ////
		if(isset($post['token'])){
			$res = $jwtED->decode_token($post['token']);
			if(isset($res->USER_ID) && $res->USER_ID > 0){
				$USER_ID 	= $res->USER_ID;
				$CREATOR_ID	= $res->CREATOR_ID;
				$WL_ID 		= $res->WL_ID;
				$ADMIN_ID 	= $res->ADMIN_ID;
				
			} else {
				$helpers->errorResponse("Token Expire");
			}
		} else {
			$helpers->errorResponse("Token not set!");
		}
		/////////////////// End //////////////////
		
		$amount = $post['amount'];
		$cr_UserId = $post['userid'];
		$usertype = $post['usertype'];
		$comment = isset($post['comment']) ? $post['comment'] : '';
		
		if(empty($amount) || $amount < 0){
			$helpers->errorResponse("Amount is missing or invalid.");
		}
		if(empty($cr_UserId)){
			$helpers->errorResponse("Userid is missing or invalid.");
		}
		if(empty($usertype)){
			$helpers->errorResponse("Usertype is missing or invalid.");
		}
		if(!in_array($post['usertype'],["RETAILER","DISTRIBUTOR"])){
			$helpers->errorResponse("Usertype accept only RETAILER or DISTRIBUTOR!");
		}

		    
		$checkUser = $mysqlClass->mysqlQuery("SELECT id FROM `add_cust` WHERE `id`='" . $cr_UserId . "' and usertype = '".$usertype."' ")->fetch(PDO::FETCH_ASSOC);
		
		if(isset($checkUser) && $checkUser['id']>0){}
		else{
			$helpers->errorResponse("Wrong user details.");
		}
		
			
			$res = $mysqlClass->mysqlQuery("SELECT wallet_balance FROM `add_cust` WHERE `id`='" . $USER_ID . "' ")->fetch(PDO::FETCH_ASSOC);
			//print_r($res);
			//die;
			$wl_v_bal  = $res['wallet_balance'];
			$transaction_id = $helpers->transaction_id_generator("CR",4);
			
			if ( $wl_v_bal > $amount ) {
				$mysqlClass->mysqlQuery("START TRANSACTION");
				if($usertype=="DISTRIBUTOR"){					
					$op_bal = $userClass->check_user_balance($cr_UserId," FOR UPDATE");
					$cl_bal = $userClass->update_wallet_balance_add_amount($cr_UserId,$amount);
					
					$dataValueDt = array(
					'dist_retail_wl_admin_id' 	=> $USER_ID,
					'transaction_id' 			=> $transaction_id,
					'agent_trid' 				=> $transaction_id,
					'opening_balance' 			=> $op_bal,
					'deposits' 					=> $amount,
					'withdrawl' 				=> 0,
					'balance' 					=> $cl_bal,
					'date_created' 				=> date("Y-m-d H:i:s"),
					'created_by' 				=> $USER_ID,
					'comments' 					=> $comment,
					'tr_type' 					=> 'CR',
					'dist_id' 					=> $cr_UserId,
					);
					$lastid = $mysqlClass->insertData(" distributor_trans ", $dataValueDt);					
					
				}
				
				if($usertype=="RETAILER"){
					$op_bal = $userClass->check_user_balance($cr_UserId," FOR UPDATE");
					$cl_bal = $userClass->update_wallet_balance_add_amount($cr_UserId,$amount);
					
					$dataValueRt = array(
					'ret_dest_wl_admin_id' 		=> $USER_ID,
					'transaction_id' 			=> $transaction_id,
					'agent_trid' 				=> $transaction_id,
					'opening_balance' 			=> $op_bal,
					'deposits' 					=> $amount,
					'withdrawl' 				=> 0,
					'balance' 					=> $cl_bal,
					'date_created' 				=> date("Y-m-d H:i:s"),
					'created_by' 				=> $USER_ID,
					'comments' 					=> $comment,
					'tr_type' 					=> 'CR',
					'retailer_id' 				=> $cr_UserId,
					);
					
					$lastid = $mysqlClass->insertData(" retailer_trans ", $dataValueRt);				
					
				}
				
				if(isset($lastid) && $lastid > 0){
					/* White label transaction */
					$Mdist_avlVbal = $userClass->check_user_balance($USER_ID," FOR UPDATE");
					$Mdist_closingBal = $userClass->update_wallet_balance_deduct_amount($USER_ID,$amount);
					
					//$mysqlClass->fetchAllData("UPDATE `add_cust` set wallet_balance = (wallet_balance - $amount) WHERE `id`='" . $USER_ID . "' and admin_id = '".$ADMIN_ID."' ");
					
					
					$dataValue = array(
					'dist_retail_wl_admin_id' 	=> $cr_UserId,
					'transaction_id' 			=> $transaction_id,
					'agent_trid' 				=> $transaction_id,
					'opening_balance' 			=> $Mdist_avlVbal,
					'deposits' 					=> 0,
					'withdrawl' 				=> $amount,
					'balance' 					=> $Mdist_closingBal,
					'date_created' 				=> date("Y-m-d H:i:s"),
					'created_by' 				=> $USER_ID,
					'comments' 					=> $comment,
					'tr_type' 					=> 'DR',
					'dist_id' 					=> $USER_ID,
					);
					$lastid = $mysqlClass->insertData(" distributor_trans ", $dataValue);
					//$helpers->redirect_page("credit-to-user");
				}
				$mysqlClass->mysqlQuery("COMMIT");
								
				
			} else {
				$helpers->errorResponse("You have insufficient balance to transafer.");
			}
					

		
		if(count($res)>0){
			$response['ERROR_CODE'] = 0;
			$response['MESSAGE'] = 'User credit successfully.';
			$response['OPENING_BAL'] = $op_bal;
			$response['CREDIT_AMOUNT'] = $amount;
			$response['CLOSING_BAL'] = $cl_bal;
		} else {
			$response['ERROR_CODE'] = 1;
			$response['MESSAGE'] = 'Some thing wrong, Transaction not complete.';
		}
		
		
	} else {
		$helpers->errorResponse("Invalid request !");
	}
	echo json_encode($response);
	
	$mysqlClass->close_connection();
	die();
?>