<?php
/************* Only for Loan and Insurance Retailer Registration (Netpaisa.in B2C) ***************/
require("../config.php");
require("classes/db_class.php");
require("classes/comman_class.php");
require("classes/user_class.php");
require("classes/common/Common.php");
require("classes/jwt_encode_decode.php");

$helpers = new Helper_class();
$commonfunction = new Common();
$mysqlClass = new Mysql_class();
$userClass = new User_class();
$jwtED = new jwt_encode_decode();


function requiredInput($inputArr, $requiredFields)
{
	foreach ($requiredFields as $v) {
		if (!isset($inputArr[$v]) || empty($inputArr[$v])) {
			$emptyError[] = $v;
		}
	}
	return $emptyError;
}

//   if($_SERVER['HTTP_X_API_KEY']==HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY']==DGFNAPASSKEY){  
//   } else {
//     $helpers->errorResponse("Authorization Invalid !");
//   }

if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST)) {

	$post = $helpers->clearSlashes($_POST);

	//echo json_encode($post); die();
	$requiredFields = array('name', 'email', 'mobile', 'domain', 'otp');
	$errorRequired = requiredInput($post, $requiredFields);
	if (!empty($errorRequired)) {
		foreach ($errorRequired as $eE) {
			$helpers->errorResponse("Please enter valid " . $eE);
		}
	}


	/* Check Reistration is Already exist with requested mobile and payment status.*/
	/* Code changed by Abhishek Tomar (refer code).*/

	$sqlUserAlreadyReg = $mysqlClass->fetchRow("add_cust", " id,wl_id ", " WHERE mobile = '" . $post['mobile'] . "' ");
	if (isset($sqlUserAlreadyReg['id']) && $sqlUserAlreadyReg['id'] > 0) {

		/*Check Payment status*/
		$sqlPaymentStatus = $mysqlClass->fetchRow("online_fund_request_details", " id,status ", " WHERE user_id = '" . $sqlUserAlreadyReg['id'] . "' ");
		if (isset($sqlPaymentStatus['id']) && $sqlUserAlreadyReg['id'] > 0) {
			$payment_status = ($sqlPaymentStatus['status'] == 0) ? "Pending" : "Success";
		} else {
			$payment_status = "Pending";
		}

		$response['ERROR_CODE'] = 0;
		$response['MESSAGE'] = "Registration Successfully done. ";
		$response['DATA']['user_id'] = $sqlUserAlreadyReg['id'];
		$response['DATA']['wl_id'] = $sqlUserAlreadyReg['wl_id'];
		$response['DATA']['payment_status'] = $payment_status;

	} else {

		/************* check special character start ***************/

		$checkname['name'] = $post['name'];

		$check_special_name = $commonfunction->check_special_details($checkname, $num = '');
		if (isset($check_special_name['msg']) && !empty($check_special_name['msg'])) {
			$helpers->errorResponse($check_special_name['msg']);
		}

		$checkarr['cname'] = $post['cname'];
		// $checkarr['address'] = $post['address'];
		$domain = $post['domain'];
		$usertype = 'RETAILER';
		$name = $post['name'];
		$otp = $post['otp'];


		if (!preg_match('/^[0-9]{10}+$/', $post['mobile'])) {
			$helpers->errorResponse('Please enter valid mobile..');
		}

		if (!filter_var($post['email'], FILTER_VALIDATE_EMAIL)) {
			$helpers->errorResponse('Please enter valid email.');
		}

		$current_time = date('Y-m-d H:i:s', time());
		$previous_time = date('Y-m-d H:i:s', strtotime("-10 min"));

		$getWlId = $mysqlClass->fetchRow("add_white_label", " user_id ", " WHERE domain = '" . $domain . "' ");

		$checkOtp = $mysqlClass->fetchRow("customer_otps", " otp ", " WHERE mobile_number = '" . $post['mobile'] . "' and otp = '" . $otp . "' and is_expired = '0' and created_at between '" . $previous_time . "' and '" . $current_time . "' and user_id = 0 ");

		if (isset($checkOtp['otp']) && $checkOtp['otp'] == $otp) {
			$dValuesOt = array(
				'is_expired' => 1,
				'updated_at' => $current_time
			);
			$mysqlClass->updateData(' customer_otps ', $dValuesOt, " WHERE mobile_number = '" . $post['mobile'] . "' and otp = '" . $otp . "' and is_expired = '0' and created_at between '" . $previous_time . "' and '" . $current_time . "' and user_id = 0 ");
		} else {
			//echo " WHERE mobile_number = '".$post['mobile']."' and otp = '".$otp."' and is_expired = '0' and created_at between '".$previous_time."' and '".$current_time."' and user_id = 0 ";

			$helpers->errorResponse('Please enter valid otp.');
		}
		//print_r($getWlId);
		if (!isset($getWlId['user_id']) || $getWlId['user_id'] != 28823) {
			$helpers->errorResponse('Wrong Source Origin.');
		}

		$getAdminId = $mysqlClass->fetchRow("add_cust", " admin_id ", " WHERE id = '" . $getWlId['user_id'] . "' ");
		//// Check Admin api_access_key ////
		$ADMIN_ID = isset($getAdminId['admin_id']) ? $getAdminId['admin_id'] : '';
		$apiAccessKey = $userClass->get_api_access_key($ADMIN_ID);

		if (empty($apiAccessKey['api_access_key'])) {
			$helpers->errorResponse('Admin API Access Key Not Set.');
		}
		$api_access_key = $apiAccessKey['api_access_key'];

		/////////////////// End //////////////////
		if ($post['refer_type'] == '2') {
			// $getdetails = $mysqlClass->fetchRow("add_cust"," creator_id,wl_id,admin_id ", " WHERE referral_code = '".$post['referred_by']."' ");
			$getdetails = $mysqlClass->mysqlQuery("select * from `add_cust` WHERE `referral_code`='" . $post['referred_by'] . "'")->fetch(PDO::FETCH_ASSOC);

			// print_r($getdetails);exit;
			$DIST_ID = $getdetails['creator_id'];
			$WL_ID = $getdetails['wl_id'];
		} else {
			$DIST_ID = 46705;
			$WL_ID = 28823;
		}
		$countUser = $mysqlClass->countRows("select id from `add_cust` WHERE wl_id='" . $WL_ID . "' and (`email`='" . $post['email'] . "' OR `mobile`='" . $post['mobile'] . "' ) ");
		if ($countUser > 0) {
			$helpers->errorResponse('User already exist with email or mobile');
		}


		$pass = bin2hex(random_bytes(5)); // generate random password
		$s_pin = mt_rand(1000, 10000);   // generate random login pin
		$hash_pass = $helpers->hashPassword($pass);
		$spin = $helpers->hashPin($s_pin);


		$distPackage = $mysqlClass->fetchRow("add_cust", " package_id ", " WHERE id = '" . $DIST_ID . "' and usertype = 'DISTRIBUTOR' ");
		if ($usertype == 'RETAILER') {
			$packageID = isset($distPackage['package_id']) ? $distPackage['package_id'] : 0;

			$service_access = isset($post['service_access']) ? implode(",", $post['service_access']) : '';
			if ($post['refer_type'] == '2') {
				$data = array(
					'name' => $name,
					'mobile' => $post['mobile'],
					'pass' => $hash_pass['encrypted'],
					'security_pin' => $spin['encrypted'],
					'master_pin' => $spin['encrypted'],
					'email' => $post['email'],
					'cname' => $post['cname'],
					'referred_by' => $post['referred_by'],
					'package_id' => $packageID,
					'status' => 'ENABLED',
					'api_access_key' => $api_access_key,
					'usertype' => "RETAILER",
					'created_on' => date("Y-m-d H:i:s"),
					'created_by' => 'DISTRIBUTOR',
					'irctc_remark' => 'b2c',
					'creator_id' => $DIST_ID,
					'wl_id' => $WL_ID,
					'admin_id' => $ADMIN_ID,
					'refer_type' => $post['refer_type'],
					'gst_file' => '',
					'service_access' => 'aeps,recharge,dmt,payout,offline_ebill,bbps_bill,e_collect,microatm,paytm_bill,aadhaarpay,loan,insurance',
					'otp_on_email' => 1,
					'otp_on_sms' => 1,
					'kyc_completed' => 1
				);

				$last_id = $mysqlClass->insertData('add_cust', $data);
			} else {
				$value = array(
					'name' => $name,
					'mobile' => $post['mobile'],
					'pass' => $hash_pass['encrypted'],
					'security_pin' => $spin['encrypted'],
					'master_pin' => $spin['encrypted'],
					'email' => $post['email'],
					'cname' => $post['cname'],
					'referred_by' => $post['referred_by'],
					'package_id' => $packageID,
					'status' => 'ENABLED',
					'api_access_key' => $api_access_key,
					'usertype' => "RETAILER",
					'created_on' => date("Y-m-d H:i:s"),
					'created_by' => 'DISTRIBUTOR',
					'irctc_remark' => 'b2c',
					'creator_id' => $DIST_ID,
					'wl_id' => $WL_ID,
					'admin_id' => $ADMIN_ID,
					'refer_type' => $post['refer_type'],
					'gst_file' => '',
					'service_access' => 'aeps,recharge,dmt,payout,offline_ebill,bbps_bill,e_collect,microatm,paytm_bill,aadhaarpay,loan,insurance',
					'otp_on_email' => 1,
					'otp_on_sms' => 1,
					'kyc_completed' => 1
				);

				$last_id = $mysqlClass->insertData('add_cust', $value);
			}
			$referral_code = $helpers->ref_id_generator($last_id);
			// $add_cust_id = $last_id;
			// $updateReferralSQL = "UPDATE add_cust SET referral_code = '{$referral_code}' WHERE id = {$add_cust_id} ";
			// $mysqlObj->mysqlQuery($updateReferralSQL);

			// $last_idd = $mysqlClass->insertData('add_cust_20220303',$value);
			if ($last_id > 0) {
				$uId = 'RT' . $last_id;

				$dValues = array(
					'user' => $uId,
					'referral_code' => $referral_code
				);
				$mysqlClass->updateData(' add_cust ', $dValues, " where id = '" . $last_id . "' ");
				$dValue = array(
					'user_id' => $last_id,
					'status' => 'Active',
					'created_by' => 'DISTRIBUTOR',
					'creator_id' => $DIST_ID,
					'package_id' => $packageID
				);

				$mysqlClass->insertData(' add_retailer ', $dValue);

				// insert into utm_referal table
				$arr_utm_referral1 = array(
					'bank' => 'https://indiasales.club',
					'category' => 0,
					'user_id' => $last_id,
					'utm_referal_code' => '15LG2326',
					'date_created' => date("Y-m-d H:i:s"),
					'wl_id' => $WL_ID,
					'admin_id' => $ADMIN_ID
				);
				$mysqlClass->insertData(' utm_referal ', $arr_utm_referral1);
				$arr_utm_referral2 = array(
					'bank' => 'IDFC',
					'category' => 1,
					'user_id' => $last_id,
					'utm_referal_code' => $referral_code,
					'date_created' => date("Y-m-d H:i:s"),
					'wl_id' => $WL_ID,
					'admin_id' => $ADMIN_ID
				);
				$mysqlClass->insertData(' utm_referal ', $arr_utm_referral2);
				/******* Create Login Id End ******************/

				/*********************** customer details start ***************/
				$business_name = "";
				$valid_on = date('Y-m-d H:i:s', strtotime('+ 60 days'));
				$cValue = array(
					'user_id' => $last_id,
					'ip' => $_SERVER['REMOTE_ADDR'],
					'shop_category' => "",
					'specify_category' => '',
					'expected_volume' => "",
					'landmark' => '',
					'c_landmark' => '',
					'c_district' => "",
					'c_state_code' => "",
					'c_pin' => "",
					'shop_owner' => '',
					'dob' => '',
					'address' => "",
					'shop_img' => "",
					'aadhar_mask' => "",
					'referral_mobile_no' => "",
					'valid_on' => $valid_on,
					'login_service_mode' => 'BANKING',
					'business_name' => $business_name,
					'reg_sub_type' => ''
				);
				$mysqlClass->insertData(' cust_details ', $cValue);

				// Sending SMS/Email with PIN
				$wlDetail = $mysqlClass->mysqlQuery(" select sms_api from add_cust where id = '" . $WL_ID . "' ");
				$resWL = $wlDetail->fetch(PDO::FETCH_ASSOC);


				$wl_domain = $mysqlClass->fetchRow("add_white_label", " domain ", " WHERE user_id = '" . $WL_ID . "' ");
				$wlDomain = !empty($wl_domain['domain']) ? $wl_domain['domain'] : '';

				//$userDetailes = "LoginId: ".$uId." Password: ".$pass." PIN: ".$s_pin." Website: ".$wlDomain;
				//$userDetailes = "Use ".$s_pin." as your login code. SSHLET";
				//	$userDetailes = "Dear Customer, The PIN for your ".$wlDomain." panel for a secured website login is ".$s_pin.". Warm Regards Digifintel";

				//$userDetailes = "Dear User, Your login pin is ".$s_pin." Don't disclose it to anyone. NETFIN";
				$userDetailes = "Your Login Pin is {$s_pin}. Please do not share with others. BEARNS";
				//Dear User, Your login pin is {#var#} Don't disclose it to anyone. Warm Regards Digifintel

				if ($resWL['sms_api'] == 'CUSTOM') {
					if ($WL_ID == WL_IDCONTANT) {
						$sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='99999999'")->fetch(PDO::FETCH_ASSOC);
					} else {
						$sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='" . $WL_ID . "' and `admin_id`='" . $ADMIN_ID . "'")->fetch(PDO::FETCH_ASSOC);
					}
				} else {
					$sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='" . $ADMIN_ID . "'")->fetch(PDO::FETCH_ASSOC);

					if (empty($sms_pack['id'])) {
						$sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='1'")->fetch(PDO::FETCH_ASSOC);
					}
				}

				$smsParameters = json_decode($sms_pack['api_parameters'], true);

				$smsParameters[$sms_pack['param_mobile_name']] = $post['mobile'];
				$smsParameters[$sms_pack['param_msg_name']] = $userDetailes;
				$smsParameters['request_type'] = $sms_pack['request_type'];
				$smsParameters['url'] = $sms_pack['url'];
				$sms_api_res = $helpers->send_msg_dynamic($smsParameters);
				//$sms_api_res =  $helpers->send_msg_dynamic_b2c_pin($smsParameters);
				// End Of sending SMS/Email

				$response['ERROR_CODE'] = 0;
				$response['MESSAGE'] = "Registration Successfully done. Please check your Mobile/Email for login details.";
				/*Added on 15-01-2022 for Razorpay process by Intzar Saifi*/
				$response['DATA']['user_id'] = $last_id;
				$response['DATA']['wl_id'] = $WL_ID;
				$response['DATA']['referral_code'] = $referral_code;
				$response['DATA']['payment_status'] = "Pending";

				if ($WL_ID != '93416') {
					$EmailSentResponse = SendOtpOnEmail($post['email'], $wlDomain, $s_pin);
				}
			} else {
				$response['ERROR_CODE'] = 1;
				$response['MESSAGE'] = 'Registration failed , Please try again';
			}
		}
	}

} else {
	$response['ERROR_CODE'] = 1;
	$response['MESSAGE'] = 'Invalid request !';
}
echo json_encode($response);
function SendOtpOnEmail($user, $Wl, $otp)
{
	global $mysqlClass;
	$WLdomain = $Wl;
	$domain = str_replace("https://", "", $WLdomain);
	$domain = rtrim($domain, "/");

	$WLdomain = $mysqlClass->getDomain($WLdomain);
	$ToEmail = $user;
	$MailTitle = "Login PIN";
	$subject = "{$domain} Login PIN";
	$userDetailes = "Dear User, Your registration OTP is " . $s_pin . ". Don't Disclose it to anyone.";
	$email_body = "<p>Dear Customer,<br></p>
					<p>The PIN for your {$domain} panel for a secured website login is " . $otp . ". <br><br></p>
					<p><strong>Warm Regards,</strong><br>{$domain}<p>
					";

	$EmailRsp = $mysqlClass->SendDynamicMessageOnEmail($ToEmail, $WLdomain, $MailTitle, $subject, $email_body);

	return $EmailRsp;
}


$mysqlClass->close_connection();
die();
?>