<?php

require "../../config.php";
require "../classes/db_class.php";
require "../classes/comman_class.php";
require "../classes/user_class.php";
require "../classes/common/Common.php";
require "../classes/jwt_encode_decode.php";

$helpers = new Helper_class();
$commonfunction = new Common();
$mysqlClass = new Mysql_class();
$userClass = new User_class();
$jwtED = new jwt_encode_decode();

if ($_SERVER['HTTP_X_API_KEY'] == HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY'] == DGFNAPASSKEY) {
} else {

    $response['ERROR_CODE'] = 1;
    $response['MESSAGE'][] = array("msg_1" => 'Authorization Invalid !');
    $response['MESSAGE'][] = array("msg_2" => "");
    $response['MESSAGE'][] = array("msg_3" => "");
    echo json_encode($response);
    die();
}

if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST)) {

    $post = $helpers->clearSlashes($_POST);

    /************* check special character start ***************/

    $checkname['name'] = $post['name'];
    $checkname['m_name'] = $post['m_name'];
    $checkname['l_name'] = $post['l_name'];

    $checkarr['cname'] = $post['cname'];
    $checkarr['c_address'] = $post['c_address'];
    $checkarr['c_landmark'] = $post['c_landmark'];
    $checkarr['address'] = $post['address'];
    $checkarr['landmark'] = $post['landmark'];
    $checkarr['gst_no'] = $post['gst_no'];

    $check_special_name = $commonfunction->check_special_details($checkname, $num = '');

    if ($check_special_name['res']) {
        $response['ERROR_CODE'] = 1;
        $response['MESSAGE'][] = array("msg_1" => $check_special_name['msg']);
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
        echo json_encode($response);
        die();
    }

    $check_special_details = $commonfunction->check_special_details($checkarr, $num = true);

    if ($check_special_details['res']) {
        $response['ERROR_CODE'] = 1;
        $response['MESSAGE'][] = array("msg_1" => $check_special_details['msg']);
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
        echo json_encode($response);
        die();
    }

    /************* check special character end ***************/

    //// Valided Token and Get Token Details ////

    if (isset($post['token'])) {
        $res = $jwtED->decode_token($post['token']);
        if (isset($res->USER_ID) && $res->USER_ID > 0) {
            $USER_ID = $res->USER_ID;
            $CREATOR_ID = $res->CREATOR_ID;
            $WL_ID = $res->WL_ID;
            $ADMIN_ID = $res->ADMIN_ID;
            $USER_TYPE = $res->USER_TYPE;

        } else {

            $response['ERROR_CODE'] = 1;
            $response['MESSAGE'][] = array("msg_1" => 'Token Expire');
            $response['MESSAGE'][] = array("msg_2" => "");
            $response['MESSAGE'][] = array("msg_3" => "");
            echo json_encode($response);
            die();
        }
    } else {

        $response['ERROR_CODE'] = 1;
        $response['MESSAGE'][] = array("msg_1" => 'Token not set!');
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
        echo json_encode($response);
        die();
    }

    /////////////////// End //////////////////

    $apiAccessKey = $userClass->get_api_access_key($ADMIN_ID);

    if (empty($apiAccessKey['api_access_key'])) {

        $response['ERROR_CODE'] = 1;
        $response['MESSAGE'][] = array("msg_1" => 'Admin API Access Key Not Set.');
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
        echo json_encode($response);
        die();
    }

    $api_access_key = $apiAccessKey['api_access_key'];

    /////////////////// End //////////////////

    /********************* Upload KYC Document Start ********************************************************************************************************/

    $url = 'https://www.digifintel.in/nps/api/aeps/upload_kyc_doc.php';

    if ($post['web'] == 1) {
        if (isset($post['aadhar_file_name']) && !empty($post['aadhar_file_name'])) {
            $tmpfile_aadhar_file = $post['aadhar_file_tmp_name'];
            $type_aadhar_file = $post['aadhar_file_type'];
            $filename_aadhar_file = basename($post['aadhar_file_name']);

            $data = array(

                'aadhar_img' => curl_file_create($tmpfile_aadhar_file, $type_aadhar_file, $filename_aadhar_file),
                'token' => rand(),
                'user_id' => $USER_ID,
            );

            $image_response = $commonfunction->upload_curl($url, $data);
            $res = json_decode($image_response, true);

            if ($res['aadhar_doc_name'] != '') {
                $aadhar_file_name = $res['aadhar_doc_name'];

            } else {
                $userDetailes = "Your aadhar card image not uploaded Please update this";
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                $response['MESSAGE'][] = array("msg_2" => "");
                $response['MESSAGE'][] = array("msg_3" => "");

                echo json_encode($response);
                die();
            }
        } else {
            $aadhar_file_name = $post['aadhar_file_old'];
        }

        if (isset($post['pan_file_name']) && !empty($post['pan_file_name'])) {

            $tmpfile_pan_file = $post['pan_file_tmp_name'];
            $type_pan_file = $post['pan_file_type'];
            $filename_pan_file = basename($post['pan_file_name']);

            $data = array(

                'pan_img' => curl_file_create($tmpfile_pan_file, $type_pan_file, $filename_pan_file),
                'token' => rand(),
                'user_id' => $USER_ID,
            );

            $image_response = $commonfunction->upload_curl($url, $data);
            $res = json_decode($image_response, true);

            if ($res['pan_doc_name'] != '') {
                $pan_file_name = $res['pan_doc_name'];

            } else {
                $userDetailes = "Your PAN card image not uploaded Please update this";
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                $response['MESSAGE'][] = array("msg_2" => "");
                $response['MESSAGE'][] = array("msg_3" => "");

                echo json_encode($response);
                die();
            }

        } else {
            $pan_file_name = $post['pan_file_old'];
        }

        if (isset($post['shop_img_name']) && !empty($post['shop_img_name'])) {

            $tmpfile_shop_img = $post['shop_img_tmp_name'];
            $type_shop_img = $post['shop_img_type'];
            $filename_shop_img = basename($post['shop_img_name']);

            $data = array(

                'shop_img' => curl_file_create($tmpfile_shop_img, $type_shop_img, $filename_shop_img),
                'token' => rand(),
                'user_id' => $USER_ID,
            );

            $image_response = $commonfunction->upload_curl($url, $data);
            $res = json_decode($image_response, true);

            if ($res['shop_doc_name'] != '') {
                $shop_file_name = $res['shop_doc_name'];

            } else {
                $userDetailes = "Your Shop image not uploaded Please update this";
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                $response['MESSAGE'][] = array("msg_2" => "");
                $response['MESSAGE'][] = array("msg_3" => "");

                echo json_encode($response);
                die();
            }

        } else {
            $shop_file_name = $post['shop_img_old'];
        }

        if (isset($post['aadhar_mask_name']) && !empty($post['aadhar_mask_name'])) {

            $tmpfile_aadhar_mask = $post['aadhar_mask_tmp_name'];
            $type_aadhar_mask = $post['aadhar_mask_type'];
            $filename_aadhar_mask = basename($post['aadhar_mask_name']);

            $data = array(
                'aadhar_mask' => curl_file_create($tmpfile_aadhar_mask, $type_aadhar_mask, $filename_aadhar_mask),
                'token' => rand(),
                'user_id' => $USER_ID,
            );

            $image_response = $commonfunction->upload_curl($url, $data);
            $res = json_decode($image_response, true);

            if ($res['mask_doc_name'] != '') {
                $aadhar_mask_file_name = $res['mask_doc_name'];
            } else {
                $userDetailes = "Your Aadhar Mask image not uploaded Please update this";
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                $response['MESSAGE'][] = array("msg_2" => "");
                $response['MESSAGE'][] = array("msg_3" => "");

                echo json_encode($response);
                die();
            }

        } else {
            $aadhar_mask_file_name = $post['aadhar_mask_old'];
        }

        if (isset($post['gst_file_name']) && !empty($post['gst_file_name'])) {

            $tmpfile_gst_file = $post['gst_file_tmp_name'];
            $type_gst_file = $post['gst_file_type'];
            $filename_gst_file = basename($post['gst_file_name']);

            $data = array(
                'gst_file' => curl_file_create($tmpfile_gst_file, $type_gst_file, $filename_gst_file),
                'token' => rand(),
                'user_id' => $USER_ID,
            );

            $image_response = $commonfunction->upload_curl($url, $data);
            $res = json_decode($image_response, true);

            if ($res['gst_doc_name'] != 0) {
                $gst_file_name = $res['gst_doc_name'];

            } else {
                $gst_file_name = '';
            }

        } else {
            $gst_file_name = $post['gst_file_old'];
        }

        /********** aadhar mask up ************/

    } else {
        if (isset($_FILES['aadhar_file']) && !empty($_FILES['aadhar_file'])) {
            $tmpfile_aadhar_file = $_FILES['aadhar_file']['tmp_name'];
            $type_aadhar_file = $_FILES['aadhar_file']['type'];
            $filename_aadhar_file = basename($_FILES['aadhar_file']['name']);
            $filesize_limit = "2000000";
            $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
            $res = sanitizeAndValidateFile('aadhar_file', $allowedExtensions, $filesize_limit);
            if (isset($res['error'])) {
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'] = $res['error'];
                echo json_encode($response);
                die();
            } else {
                $data = array(

                    'aadhar_img' => curl_file_create($tmpfile_aadhar_file, $type_aadhar_file, $filename_aadhar_file),
                    'token' => rand(),
                    'user_id' => $USER_ID,
                );

                $image_response = $commonfunction->upload_curl($url, $data);
                $res = json_decode($image_response, true);

                if ($res['aadhar_doc_name'] != '') {
                    $aadhar_file_name = $res['aadhar_doc_name'];

                } else {
                    $userDetailes = "Your aadhar card image not uploaded Please update this";
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                    $response['MESSAGE'][] = array("msg_2" => "");
                    $response['MESSAGE'][] = array("msg_3" => "");

                    echo json_encode($response);
                    die();
                }
            }

        } else {
            $aadhar_file_name = $post['aadhar_file_old'];
        }

        if (isset($_FILES['pan_file']) && !empty($_FILES['pan_file'])) {
            $tmpfile_pan_file = $_FILES['pan_file']['tmp_name'];
            $type_pan_file = $_FILES['pan_file']['type'];
            $filename_pan_file = basename($_FILES['pan_file']['name']);
            $filesize_limit = "2000000";
            $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
            $res = sanitizeAndValidateFile('pan_file', $allowedExtensions, $filesize_limit);
            if (isset($res['error'])) {
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'] = $res['error'];
                echo json_encode($response);
                die();
            } else {
                $data = array(

                    'pan_img' => curl_file_create($tmpfile_pan_file, $type_pan_file, $filename_pan_file),
                    'token' => rand(),
                    'user_id' => $USER_ID,
                );

                $image_response = $commonfunction->upload_curl($url, $data);
                $res = json_decode($image_response, true);

                if ($res['pan_doc_name'] != '') {
                    $pan_file_name = $res['pan_doc_name'];

                } else {
                    $userDetailes = "Your PAN card image not uploaded Please update this";
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                    $response['MESSAGE'][] = array("msg_2" => "");
                    $response['MESSAGE'][] = array("msg_3" => "");

                    echo json_encode($response);
                    die();
                }
            }

        } else {
            $pan_file_name = $post['pan_file_old'];
        }

        if (isset($_FILES['shop_img']) && !empty($_FILES['shop_img'])) {
            $tmpfile_shop_img = $_FILES['shop_img']['tmp_name'];
            $type_shop_img = $_FILES['shop_img']['type'];
            $filename_shop_img = basename($_FILES['shop_img']['name']);
            $filesize_limit = "2000000";
            $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
            $res = sanitizeAndValidateFile('shop_img', $allowedExtensions, $filesize_limit);
            if (isset($res['error'])) {
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'] = $res['error'];
                echo json_encode($response);
                die();
            } else {
                $data = array(

                    'shop_img' => curl_file_create($tmpfile_shop_img, $type_shop_img, $filename_shop_img),
                    'token' => rand(),
                    'user_id' => $USER_ID,
                );

                $image_response = $commonfunction->upload_curl($url, $data);
                $res = json_decode($image_response, true);

                if ($res['shop_doc_name'] != '') {
                    $shop_file_name = $res['shop_doc_name'];

                } else {
                    $userDetailes = "Your Shop image not uploaded Please update this";
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                    $response['MESSAGE'][] = array("msg_2" => "");
                    $response['MESSAGE'][] = array("msg_3" => "");

                    echo json_encode($response);
                    die();
                }
            }
        } else {
            $shop_file_name = $post['shop_img_old'];
        }

        if (isset($_FILES['aadhar_mask']) && !empty($_FILES['aadhar_mask'])) {

            $tmpfile_aadhar_mask = $_FILES['aadhar_mask']['tmp_name'];
            $type_aadhar_mask = $_FILES['aadhar_mask']['type'];
            $filename_aadhar_mask = basename($_FILES['aadhar_mask']['name']);
            $filesize_limit = "2000000";
            $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
            $res = sanitizeAndValidateFile('aadhar_mask', $allowedExtensions, $filesize_limit);
            if (isset($res['error'])) {
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'] = $res['error'];
                echo json_encode($response);
                die();
            } else {
                $data = array(
                    'aadhar_mask' => curl_file_create($tmpfile_aadhar_mask, $type_aadhar_mask, $filename_aadhar_mask),
                    'token' => rand(),
                    'user_id' => $USER_ID,
                );

                $image_response = $commonfunction->upload_curl($url, $data);
                $res = json_decode($image_response, true);

                if ($res['mask_doc_name'] != '') {
                    $aadhar_mask_file_name = $res['mask_doc_name'];
                } else {
                    $userDetailes = "Your Aadhar Mask image not uploaded Please update this";
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                    $response['MESSAGE'][] = array("msg_2" => "");
                    $response['MESSAGE'][] = array("msg_3" => "");

                    echo json_encode($response);
                    die();
                }
            }

        } else {
            $aadhar_mask_file_name = $post['aadhar_mask_old'];
        }

        if (isset($_FILES['gst_file']) && !empty($_FILES['gst_file'])) {

            $tmpfile_gst_file = $_FILES['gst_file']['tmp_name'];
            $type_gst_file = $_FILES['gst_file']['type'];
            $filename_gst_file = basename($_FILES['gst_file']['name']);
            $filesize_limit = "2000000";
            $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
            $res = sanitizeAndValidateFile('gst_file', $allowedExtensions, $filesize_limit);
            if (isset($res['error'])) {
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'] = $res['error'];
                echo json_encode($response);
                die();
            } else {
                $data = array(
                    'gst_file' => curl_file_create($tmpfile_gst_file, $type_gst_file, $filename_gst_file),
                    'token' => rand(),
                    'user_id' => $USER_ID,
                );

                $image_response = $commonfunction->upload_curl($url, $data);
                $res = json_decode($image_response, true);

                if ($res['gst_doc_name'] != '') {
                    $gst_file_name = $res['gst_doc_name'];

                } else {
                    $gst_file_name = '';
                }
            }

        } else {
            $gst_file_name = $post['gst_file_old'];
        }

    }

    /********************* Upload KYC Document End ***********************************************************************************************************/

    $var = $post['dob'];
    $date = str_replace('/', '-', $var);
    $dob = date('Y-m-d', strtotime($date));

    $name = $post['name'] . ' ' . $post['m_name'] . ' ' . $post['l_name'];

    $value = array(
        'name' => $name,
        'mobile' => $post['mobile'],
        'cname' => $post['cname'],
        'state_code' => $post['c_state'],
        'district_code' => $post['c_city'],
        'pin' => $post['c_pin'],
        'aadhar_no' => $post['aadhar_no'],
        'pan_no' => $post['pan_no'],
        'gst_no' => $post['gst_no'],
        'aadhar_file' => $aadhar_file_name,
        'pan_file' => $pan_file_name,
        'gst_file' => $gst_file_name,
        'address' => $post['c_address'],
    );

    $updateResult = $mysqlClass->updateData(' add_cust ', $value, " where id = '" . $USER_ID . "' ");

    /*********************** customer details start ***************/

    $valid_on = date('Y-m-d H:i:s', strtotime('+ 60 days'));

    $checkData = $mysqlClass->mysqlQuery("select * from `cust_details` WHERE user_id='" . $USER_ID . "' ");

    if ($checkData->rowCount() == 0) {
        if (isset($aadhar_mask_file_name) && isset($pan_file_name) && isset($post['aadhar_no']) && isset($post['pan_no'])) {

            $cValue = array(

                'user_id' => $USER_ID,
                'ip' => $_SERVER['REMOTE_ADDR'],
                'shop_category' => $post['shop_category'],
                'expected_volume' => $post['expected_volume'],
                'landmark' => $post['landmark'],
                'c_landmark' => $post['c_landmark'],
                'c_district' => $post['city'],
                'c_state_code' => $post['state'],
                'c_pin' => $post['pin'],
                'dob' => $dob,
                'address' => $post['address'],
                'shop_img' => $shop_file_name,
                'aadhar_mask' => $aadhar_mask_file_name,
                'is_kyc' => '1',
                'valid_on' => $valid_on,
            );

        } else {

            $cValue = array(

                'user_id' => $USER_ID,
                'ip' => $_SERVER['REMOTE_ADDR'],
                'shop_category' => $post['shop_category'],
                'expected_volume' => $post['expected_volume'],
                'landmark' => $post['landmark'],
                'c_landmark' => $post['c_landmark'],
                'c_district' => $post['city'],
                'c_state_code' => $post['state'],
                'c_pin' => $post['pin'],
                'dob' => $dob,
                'address' => $post['address'],
                'shop_img' => $shop_file_name,
                'aadhar_mask' => $aadhar_mask_file_name,
                'valid_on' => $valid_on,

            );
        }

        $mysqlClass->insertData(' cust_details ', $cValue);

    } else {
        if (isset($aadhar_mask_file_name) && isset($pan_file_name) && isset($post['aadhar_no']) && isset($post['pan_no'])) {

            $cValue = array(

                'ip' => $_SERVER['REMOTE_ADDR'],
                'shop_category' => $post['shop_category'],
                'expected_volume' => $post['expected_volume'],
                'landmark' => $post['landmark'],
                'c_landmark' => $post['c_landmark'],
                'c_district' => $post['city'],
                'c_state_code' => $post['state'],
                'c_pin' => $post['pin'],
                'dob' => $dob,
                'address' => $post['address'],
                'shop_img' => $shop_file_name,
                'aadhar_mask' => $aadhar_mask_file_name,
                'is_kyc' => '1',
                'valid_on' => $valid_on,
            );

        } else {

            $cValue = array(

                'ip' => $_SERVER['REMOTE_ADDR'],
                'shop_category' => $post['shop_category'],
                'expected_volume' => $post['expected_volume'],
                'landmark' => $post['landmark'],
                'c_landmark' => $post['c_landmark'],
                'c_district' => $post['city'],
                'c_state_code' => $post['state'],
                'c_pin' => $post['pin'],
                'dob' => $dob,
                'address' => $post['address'],
                'shop_img' => $shop_file_name,
                'aadhar_mask' => $aadhar_mask_file_name,
                'valid_on' => $valid_on,

            );
        }

        $updateCusDtils = $mysqlClass->updateData(' cust_details ', $cValue, " where user_id = '" . $USER_ID . "' ");
    }

    if ($updateCusDtils) {

        $response['ERROR_CODE'] = 0;
        $response['MESSAGE'][] = array("msg_1" => 'Account Profile Updated');
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
    } else {
        $response['ERROR_CODE'] = 1;
        $response['MESSAGE'][] = array("msg_1" => 'Account Profile Updation failed');
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
    }

    /*********************** customer details end ***************/

} else {
    $response['ERROR_CODE'] = 1;
    $response['MESSAGE'][] = array("msg_1" => 'Invalid request !');
    $response['MESSAGE'][] = array("msg_2" => "");
    $response['MESSAGE'][] = array("msg_3" => "");
}

echo json_encode($response);

$mysqlClass->close_connection();
die();
