<?php

require "../../config.php";
require "../classes/db_class.php";
require "../classes/comman_class.php";
require "../classes/user_class.php";
require "../classes/common/Common.php";
require "../classes/jwt_encode_decode.php";

$helpers = new Helper_class();
$commonfunction = new Common();
$mysqlClass = new Mysql_class();
$userClass = new User_class();
$jwtED = new jwt_encode_decode();

if ($_SERVER['HTTP_X_API_KEY'] == HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY'] == DGFNAPASSKEY) {
} else {

    $response['ERROR_CODE'] = 1;
    $response['MESSAGE'][] = array("msg_1" => 'Authorization Invalid !');
    $response['MESSAGE'][] = array("msg_2" => "");
    $response['MESSAGE'][] = array("msg_3" => "");
    echo json_encode($response);
    die();
}

if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST)) {

    $post = $helpers->clearSlashes($_POST);

    /************* check special character start ***************/

    $checkname['name'] = $post['name'];
    $checkname['m_name'] = $post['m_name'];
    $checkname['l_name'] = $post['l_name'];

    $checkarr['cname'] = $post['cname'];
    $checkarr['c_address'] = $post['c_address'];
    $checkarr['c_landmark'] = $post['c_landmark'];
    $checkarr['address'] = $post['address'];
    $checkarr['landmark'] = $post['landmark'];
    $checkarr['gst_no'] = $post['gst_no'];

    $check_special_name = $commonfunction->check_special_details($checkname, $num = '');

    if ($check_special_name['res']) {
        $response['ERROR_CODE'] = 1;
        $response['MESSAGE'][] = array("msg_1" => $check_special_name['msg']);
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
        echo json_encode($response);
        die();
    }

    $check_special_details = $commonfunction->check_special_details($checkarr, $num = true);

    if ($check_special_details['res']) {
        $response['ERROR_CODE'] = 1;
        $response['MESSAGE'][] = array("msg_1" => $check_special_details['msg']);
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
        echo json_encode($response);
        die();
    }

    /************* check special character end ***************/

    //// Valided Token and Get Token Details ////

    if (isset($post['token'])) {
        $res = $jwtED->decode_token($post['token']);

        if (isset($res->USER_ID) && $res->USER_ID > 0) {
            $USER_ID = $res->USER_ID;
            $CREATOR_ID = $res->CREATOR_ID;
            $WL_ID = $res->WL_ID;
            $ADMIN_ID = $res->ADMIN_ID;
            $USER_TYPE = $res->USER_TYPE;

        } else {

            $response['ERROR_CODE'] = 1;
            $response['MESSAGE'][] = array("msg_1" => 'Token Expire');
            $response['MESSAGE'][] = array("msg_2" => "");
            $response['MESSAGE'][] = array("msg_3" => "");
            echo json_encode($response);
            die();
        }

    } else {

        $response['ERROR_CODE'] = 1;
        $response['MESSAGE'][] = array("msg_1" => 'Token not set!');
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
        echo json_encode($response);
        die();
    }

    if ($post['web'] != 1) {
        $USER_ID = $post['user_id'];
    }

    /////////////////// End //////////////////

    //// Check Admin api_access_key ////

    $apiAccessKey = $userClass->get_api_access_key($ADMIN_ID);

    if (empty($apiAccessKey['api_access_key'])) {

        $response['ERROR_CODE'] = 1;
        $response['MESSAGE'][] = array("msg_1" => 'Admin API Access Key Not Set.');
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
        echo json_encode($response);
        die();
    }

    $api_access_key = $apiAccessKey['api_access_key'];

    /////////////////// End //////////////////

    if (preg_match('/^[0-9]{10}+$/', $post['mobile']) && filter_var($post['email'], FILTER_VALIDATE_EMAIL) && preg_match("/^([a-zA-Z]){5}([0-9]){4}([a-zA-Z]){1}?$/", $post['pan_no']) && preg_match('/^[0-9]{12}+$/', $post['aadhar_no'])) {

        /********************* Upload KYC Document Start ********************************************************************************************************/

        $url = 'https://www.digifintel.in/nps/api/aeps/upload_kyc_doc.php';

        if ($post['web'] == 1) {
            if (isset($post['aadhar_file_name']) && !empty($post['aadhar_file_name'])) {
                $tmpfile_aadhar_file = $post['aadhar_file_tmp_name'];
                $type_aadhar_file = $post['aadhar_file_type'];
                $filename_aadhar_file = basename($post['aadhar_file_name']);

                $data = array(

                    'aadhar_img' => curl_file_create($tmpfile_aadhar_file, $type_aadhar_file, $filename_aadhar_file),
                    'token' => rand(),
                    'user_id' => $USER_ID,
                );

                $image_response = $commonfunction->upload_curl($url, $data);
                $res = json_decode($image_response, true);

                if ($res['aadhar_doc_name'] != '') {
                    $aadhar_file_name = $res['aadhar_doc_name'];

                } else {
                    $userDetailes = "Your aadhar card image not uploaded Please update this";
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                    $response['MESSAGE'][] = array("msg_2" => "");
                    $response['MESSAGE'][] = array("msg_3" => "");

                    echo json_encode($response);
                    die();
                }
            } else {
                $aadhar_file_name = $post['aadhar_file_old'];
            }

            if (isset($post['pan_file_name']) && !empty($post['pan_file_name'])) {

                $tmpfile_pan_file = $post['pan_file_tmp_name'];
                $type_pan_file = $post['pan_file_type'];
                $filename_pan_file = basename($post['pan_file_name']);

                $data = array(

                    'pan_img' => curl_file_create($tmpfile_pan_file, $type_pan_file, $filename_pan_file),
                    'token' => rand(),
                    'user_id' => $USER_ID,
                );

                $image_response = $commonfunction->upload_curl($url, $data);
                $res = json_decode($image_response, true);

                if ($res['pan_doc_name'] != '') {
                    $pan_file_name = $res['pan_doc_name'];

                } else {
                    $userDetailes = "Your PAN card image not uploaded Please update this";
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                    $response['MESSAGE'][] = array("msg_2" => "");
                    $response['MESSAGE'][] = array("msg_3" => "");

                    echo json_encode($response);
                    die();
                }

            } else {
                $pan_file_name = $post['pan_file_old'];
            }

            if (isset($post['shop_img_name']) && !empty($post['shop_img_name'])) {

                $tmpfile_shop_img = $post['shop_img_tmp_name'];
                $type_shop_img = $post['shop_img_type'];
                $filename_shop_img = basename($post['shop_img_name']);

                $data = array(

                    'shop_img' => curl_file_create($tmpfile_shop_img, $type_shop_img, $filename_shop_img),
                    'token' => rand(),
                    'user_id' => $USER_ID,
                );

                $image_response = $commonfunction->upload_curl($url, $data);
                $res = json_decode($image_response, true);

                if ($res['shop_doc_name'] != '') {
                    $shop_file_name = $res['shop_doc_name'];

                } else {
                    $userDetailes = "Your Shop image not uploaded Please update this";
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                    $response['MESSAGE'][] = array("msg_2" => "");
                    $response['MESSAGE'][] = array("msg_3" => "");

                    echo json_encode($response);
                    die();
                }

            } else {
                $shop_file_name = $post['shop_img_old'];
            }

            if (isset($post['aadhar_mask_name']) && !empty($post['aadhar_mask_name'])) {

                $tmpfile_aadhar_mask = $post['aadhar_mask_tmp_name'];
                $type_aadhar_mask = $post['aadhar_mask_type'];
                $filename_aadhar_mask = basename($post['aadhar_mask_name']);

                $data = array(
                    'aadhar_mask' => curl_file_create($tmpfile_aadhar_mask, $type_aadhar_mask, $filename_aadhar_mask),
                    'token' => rand(),
                    'user_id' => $USER_ID,
                );

                $image_response = $commonfunction->upload_curl($url, $data);
                $res = json_decode($image_response, true);

                if ($res['mask_doc_name'] != '') {
                    $aadhar_mask_file_name = $res['mask_doc_name'];
                } else {
                    $userDetailes = "Your Aadhar Mask image not uploaded Please update this";
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                    $response['MESSAGE'][] = array("msg_2" => "");
                    $response['MESSAGE'][] = array("msg_3" => "");

                    echo json_encode($response);
                    die();
                }

            } else {
                $aadhar_mask_file_name = $post['aadhar_mask_old'];
            }

            if (isset($post['gst_file_name']) && !empty($post['gst_file_name'])) {

                $tmpfile_gst_file = $post['gst_file_tmp_name'];
                $type_gst_file = $post['gst_file_type'];
                $filename_gst_file = basename($post['gst_file_name']);

                $data = array(
                    'gst_file' => curl_file_create($tmpfile_gst_file, $type_gst_file, $filename_gst_file),
                    'token' => rand(),
                    'user_id' => $USER_ID,
                );

                $image_response = $commonfunction->upload_curl($url, $data);
                $res = json_decode($image_response, true);

                if ($res['gst_doc_name'] != 0) {
                    $gst_file_name = $res['gst_doc_name'];

                } else {
                    $gst_file_name = '';
                }

            } else {
                $gst_file_name = $post['gst_file_old'];
            }

            /********** aadhar mask up ************/

        } else {

            /************* Get old file for app **********************************/

            $imagesDetail = $mysqlClass->mysqlQuery("SELECT ac.aadhar_file, ac.pan_file, ac.gst_file, cd.shop_img, cd.aadhar_mask FROM `add_cust` as ac LEFT JOIN cust_details as cd ON ac.id = cd.user_id WHERE `id`='" . $USER_ID . "'")->fetch(PDO::FETCH_ASSOC);

            $priv_aadhar_file = $imagesDetail['aadhar_file'];
            $priv_pan_file = $imagesDetail['pan_file'];
            $priv_gst_file = $imagesDetail['gst_file'];
            $priv_shop_img = $imagesDetail['shop_img'];
            $priv_aadhar_mask = $imagesDetail['aadhar_mask'];

            /************* Get old file for app **********************************/

            if (isset($_FILES['aadhar_file']) && !empty($_FILES['aadhar_file'])) {
                $tmpfile_aadhar_file = $_FILES['aadhar_file']['tmp_name'];
                $type_aadhar_file = $_FILES['aadhar_file']['type'];
                $filename_aadhar_file = basename($_FILES['aadhar_file']['name']);
                $filesize_limit = "2000000";
                $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
                $res = sanitizeAndValidateFile('aadhar_file', $allowedExtensions, $filesize_limit);
                if (isset($res['error'])) {
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'] = $res['error'];
                    echo json_encode($response);
                    die();
                } else {
                    $data = array(

                        'aadhar_img' => curl_file_create($tmpfile_aadhar_file, $type_aadhar_file, $filename_aadhar_file),
                        'token' => rand(),
                        'user_id' => $USER_ID,
                    );

                    $image_response = $commonfunction->upload_curl($url, $data);
                    $res = json_decode($image_response, true);

                    if ($res['aadhar_doc_name'] != '') {
                        $aadhar_file_name = $res['aadhar_doc_name'];

                    } else {
                        $userDetailes = "Your aadhar card image not uploaded Please update this";
                        $response['ERROR_CODE'] = 1;
                        $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                        $response['MESSAGE'][] = array("msg_2" => "");
                        $response['MESSAGE'][] = array("msg_3" => "");

                        echo json_encode($response);
                        die();
                    }
                }

            } else {
                $aadhar_file_name = $priv_aadhar_file;
            }

            if (isset($_FILES['pan_file']) && !empty($_FILES['pan_file'])) {
                $tmpfile_pan_file = $_FILES['pan_file']['tmp_name'];
                $type_pan_file = $_FILES['pan_file']['type'];
                $filename_pan_file = basename($_FILES['pan_file']['name']);
                $filesize_limit = "2000000";
                $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
                $res = sanitizeAndValidateFile('pan_file', $allowedExtensions, $filesize_limit);
                if (isset($res['error'])) {
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'] = $res['error'];
                    echo json_encode($response);
                    die();
                } else {
                    $data = array(

                        'pan_img' => curl_file_create($tmpfile_pan_file, $type_pan_file, $filename_pan_file),
                        'token' => rand(),
                        'user_id' => $USER_ID,
                    );

                    $image_response = $commonfunction->upload_curl($url, $data);
                    $res = json_decode($image_response, true);

                    if ($res['pan_doc_name'] != '') {
                        $pan_file_name = $res['pan_doc_name'];

                    } else {
                        $userDetailes = "Your PAN card image not uploaded Please update this";
                        $response['ERROR_CODE'] = 1;
                        $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                        $response['MESSAGE'][] = array("msg_2" => "");
                        $response['MESSAGE'][] = array("msg_3" => "");

                        echo json_encode($response);
                        die();
                    }
                }

            } else {
                $pan_file_name = $priv_pan_file;
            }

            if (isset($_FILES['shop_img']) && !empty($_FILES['shop_img'])) {
                $tmpfile_shop_img = $_FILES['shop_img']['tmp_name'];
                $type_shop_img = $_FILES['shop_img']['type'];
                $filename_shop_img = basename($_FILES['shop_img']['name']);
                $filesize_limit = "2000000";
                $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
                $res = sanitizeAndValidateFile('shop_img', $allowedExtensions, $filesize_limit);
                if (isset($res['error'])) {
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'] = $res['error'];
                    echo json_encode($response);
                    die();
                } else {
                    $data = array(

                        'shop_img' => curl_file_create($tmpfile_shop_img, $type_shop_img, $filename_shop_img),
                        'token' => rand(),
                        'user_id' => $USER_ID,
                    );

                    $image_response = $commonfunction->upload_curl($url, $data);
                    $res = json_decode($image_response, true);

                    if ($res['shop_doc_name'] != '') {
                        $shop_file_name = $res['shop_doc_name'];

                    } else {
                        $userDetailes = "Your Shop image not uploaded Please update this";
                        $response['ERROR_CODE'] = 1;
                        $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                        $response['MESSAGE'][] = array("msg_2" => "");
                        $response['MESSAGE'][] = array("msg_3" => "");

                        echo json_encode($response);
                        die();
                    }
                }
            } else {
                $shop_file_name = $priv_shop_img;
            }

            if (isset($_FILES['aadhar_mask']) && !empty($_FILES['aadhar_mask'])) {

                $tmpfile_aadhar_mask = $_FILES['aadhar_mask']['tmp_name'];
                $type_aadhar_mask = $_FILES['aadhar_mask']['type'];
                $filename_aadhar_mask = basename($_FILES['aadhar_mask']['name']);
                $filesize_limit = "2000000";
                $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
                $res = sanitizeAndValidateFile('aadhar_mask', $allowedExtensions, $filesize_limit);
                if (isset($res['error'])) {
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'] = $res['error'];
                    echo json_encode($response);
                    die();
                } else {
                    $data = array(
                        'aadhar_mask' => curl_file_create($tmpfile_aadhar_mask, $type_aadhar_mask, $filename_aadhar_mask),
                        'token' => rand(),
                        'user_id' => $USER_ID,
                    );

                    $image_response = $commonfunction->upload_curl($url, $data);
                    $res = json_decode($image_response, true);

                    if ($res['mask_doc_name'] != '') {
                        $aadhar_mask_file_name = $res['mask_doc_name'];
                    } else {
                        $userDetailes = "Your Aadhar Mask image not uploaded Please update this";
                        $response['ERROR_CODE'] = 1;
                        $response['MESSAGE'][] = array("msg_1" => $userDetailes);
                        $response['MESSAGE'][] = array("msg_2" => "");
                        $response['MESSAGE'][] = array("msg_3" => "");

                        echo json_encode($response);
                        die();
                    }
                }

            } else {
                $aadhar_mask_file_name = $priv_aadhar_mask;
            }

            if (isset($_FILES['gst_file']) && !empty($_FILES['gst_file'])) {

                $tmpfile_gst_file = $_FILES['gst_file']['tmp_name'];
                $type_gst_file = $_FILES['gst_file']['type'];
                $filename_gst_file = basename($_FILES['gst_file']['name']);
                $filesize_limit = "2000000";
                $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
                $res = sanitizeAndValidateFile('gst_file', $allowedExtensions, $filesize_limit);
                if (isset($res['error'])) {
                    $response['ERROR_CODE'] = 1;
                    $response['MESSAGE'] = $res['error'];
                    echo json_encode($response);
                    die();
                } else {
                    $data = array(
                        'gst_file' => curl_file_create($tmpfile_gst_file, $type_gst_file, $filename_gst_file),
                        'token' => rand(),
                        'user_id' => $USER_ID,
                    );

                    $image_response = $commonfunction->upload_curl($url, $data);
                    $res = json_decode($image_response, true);

                    if ($res['gst_doc_name'] != '') {
                        $gst_file_name = $res['gst_doc_name'];

                    } else {
                        $gst_file_name = '';
                    }
                }

            } else {
                $gst_file_name = $priv_gst_file;
            }

        }

        /********************* Upload KYC Document End ***********************************************************************************************************/

        $var = $post['dob'];
        $date = str_replace('/', '-', $var);
        $dob = date('Y-m-d', strtotime($date));

        $name = $post['name'] . ' ' . $post['m_name'] . ' ' . $post['l_name'];

        $value = array(

            'name' => $name,
            'mobile' => $post['mobile'],
            'cname' => $post['cname'],
            'state_code' => $post['c_state'],
            'district_code' => $post['c_city'],
            'pin' => $post['c_pin'],
            'aadhar_no' => $post['aadhar_no'],
            'pan_no' => $post['pan_no'],
            'gst_no' => $post['gst_no'],
            'aadhar_file' => $aadhar_file_name,
            'pan_file' => $pan_file_name,
            'gst_file' => $gst_file_name,
            'address' => $post['c_address'],
        );

        $updateRun = $mysqlClass->updateData(' add_cust ', $value, " where id = '" . $USER_ID . "' ");

        /*********************** customer details start ***************/

        $valid_on = date('Y-m-d H:i:s', strtotime('+ 60 days'));

        $checkData = $mysqlClass->mysqlQuery("select * from `cust_details` WHERE user_id='" . $USER_ID . "' ");

        if ($checkData->rowCount() == 0) {
            if (isset($aadhar_mask_file_name) && isset($pan_file_name) && isset($post['aadhar_no']) && isset($post['pan_no'])) {

                $cValue = array(

                    'user_id' => $USER_ID,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'shop_category' => $post['shop_category'],
                    'expected_volume' => $post['expected_volume'],
                    'landmark' => $post['landmark'],
                    'c_landmark' => $post['c_landmark'],
                    'c_district' => $post['city'],
                    'c_state_code' => $post['state'],
                    'c_pin' => $post['pin'],
                    'dob' => $dob,
                    'address' => $post['address'],
                    'shop_img' => $shop_file_name,
                    'aadhar_mask' => $aadhar_mask_file_name,
                    'is_kyc' => '1',
                    'valid_on' => $valid_on,
                );

            } else {

                $cValue = array(

                    'user_id' => $USER_ID,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'shop_category' => $post['shop_category'],
                    'expected_volume' => $post['expected_volume'],
                    'landmark' => $post['landmark'],
                    'c_landmark' => $post['c_landmark'],
                    'c_district' => $post['city'],
                    'c_state_code' => $post['state'],
                    'c_pin' => $post['pin'],
                    'dob' => $dob,
                    'address' => $post['address'],
                    'shop_img' => $shop_file_name,
                    'aadhar_mask' => $aadhar_mask_file_name,
                    'valid_on' => $valid_on,

                );
            }

            $mysqlClass->insertData(' cust_details ', $cValue);

        } else {
            if (isset($aadhar_mask_file_name) && isset($pan_file_name) && isset($post['aadhar_no']) && isset($post['pan_no'])) {

                $cValue = array(

                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'shop_category' => $post['shop_category'],
                    'expected_volume' => $post['expected_volume'],
                    'landmark' => $post['landmark'],
                    'c_landmark' => $post['c_landmark'],
                    'c_district' => $post['city'],
                    'c_state_code' => $post['state'],
                    'c_pin' => $post['pin'],
                    'dob' => $dob,
                    'address' => $post['address'],
                    'shop_img' => $shop_file_name,
                    'aadhar_mask' => $aadhar_mask_file_name,
                    'is_kyc' => '1',
                    'valid_on' => $valid_on,
                );

            } else {

                $cValue = array(

                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'shop_category' => $post['shop_category'],
                    'expected_volume' => $post['expected_volume'],
                    'landmark' => $post['landmark'],
                    'c_landmark' => $post['c_landmark'],
                    'c_district' => $post['city'],
                    'c_state_code' => $post['state'],
                    'c_pin' => $post['pin'],
                    'dob' => $dob,
                    'address' => $post['address'],
                    'shop_img' => $shop_file_name,
                    'aadhar_mask' => $aadhar_mask_file_name,
                    'valid_on' => $valid_on,

                );
            }

            $updateCusDtils = $mysqlClass->updateData(' cust_details ', $cValue, " where user_id = '" . $USER_ID . "' ");
        }

        /*********************** customer details end ***************/

        /****************** AEPS kyc registration start *****************/

        if ($post['AEPS1'] == 1) {
            if (isset($post['aadhar_mobile']) && isset($post['aadhar_otp']) && $post['aadhar_mobile'] && $post['aadhar_otp'] != '') {

                $aadhar_otp = $post['aadhar_otp'];

                $request_param = ['api_access_key' => $api_access_key, 'mobile' => $post['aadhar_mobile'], 'name' => $post['name'], 'email' => $post['email'], 'pincode' => $post['c_pin'], 'company' => $post['cname'], 'pan' => $post['pan_no'], 'address' => $post['c_address'], 'otp' => $aadhar_otp];

                $outlet_json = $helpers->netpaisa_curl($outlet_register, $request_param);

                $outlet_result = json_decode($outlet_json, true);

                if ($outlet_result['ERR_STATE'] == 0 && isset($outlet_result['DATA']['statuscode']) && $outlet_result['DATA']['statuscode'] == "TXN") {

                    $valueOutlet = array(
                        'user_id' => $USER_ID,
                        'outletid' => $outlet_result['DATA']['outlet_id'],
                        'name' => $outlet_result['DATA']['contact_person'],
                        'email' => $outlet_result['DATA']['email_id'],
                        'mobile' => $outlet_result['DATA']['mobile_number'],
                        'company' => $outlet_result['DATA']['outlet_name'],
                        'address' => $post['c_address'],
                        'pincode' => $post['c_pin'],
                        'pan_no' => $outlet_result['DATA']['pan_no'],
                        'dob' => $dob,
                        'registration_date' => date("Y-m-d H:i:s"),
                        'outlet_status' => $outlet_result['DATA']['outlet_status'],
                        'outlet_kyc' => $outlet_result['DATA']['kyc_status'],
                        'status' => $outlet_result['DATA']['kyc_status'],
                        'sources' => 'I',
                    );

                    $aeps_response = $mysqlClass->insertData('outlet_kyc', $valueOutlet);

                    if ($aeps_response > 0) {
                        $aadhaar_id = 14;

                        /*$img_encoded_url = base64_encode(file_get_contents( BASE_URL . "uploads/kyc-doc/".$post['aadhar_file_name']));*/

                        $target_dir = "https://www.digifintel.in/nps/apiUser/pan_img/";

                        $img_encoded_url = base64_encode($target_dir . $aadhar_file_name);

                        $aeps_fields = [
                            'api_access_key' => $api_access_key,
                            'outletid' => $outlet_result['DATA']['outlet_id'],
                            'pan_no' => $outlet_result['DATA']['pan_no'],
                            'aadhar_no' => $post['aadhar_no'],
                            'aadharid' => $aadhaar_id,
                            'aadharfilename' => 'data:image/jpeg;base64,' . $img_encoded_url,
                        ];

                        $aeps_result = $helpers->netpaisa_curl($aadhar_upload_kyc_document, $aeps_fields);
                        $rech_data = json_decode($aeps_result, true);

                        if (!empty($rech_data)) {

                            $aeps_status = (int) $rech_data['ERR_STATE'];

                            if ($aeps_status == 0) {

                                $aadharFilename = $aadhar_file_name;
                                $mysqlClass->mysqlQuery("UPDATE outlet_kyc SET `aadhaarimg`= '$aadharFilename' WHERE `user_id`='$USER_ID' and `sources`='I'");

                            }
                        }
                    }

                } else {
                    $kycerror = "AEPS 1 KYC  " . $outlet_result['MSG'];
                }

            } else {
                $kycerror = "Please enter aadhar mobile OTP";
            }
        }

        /****************** AEPS kyc registration end *****************/

        /********* AEPS 2 kyc registration Start ***********/

        if ($post['AEPS2'] == 1) {

            $stateDetail = $commonfunction->getStateNameByStateCode($post['state']);
            $stateDetail_c = $commonfunction->getStateNameByStateCode($post['c_state']);

            $cityDetail = $commonfunction->getCityNameByCityCode($post['state'], $post['city']);
            $cityDetail_c = $commonfunction->getCityNameByCityCode($post['c_state'], $post['c_city']);

            $stateName = $stateDetail['state_name'];
            $stateName_c = $stateDetail_c['state_name'];

            $cityName = $cityDetail['district_name'];
            $cityName_c = $cityDetail_c['district_name'];

            /******************* Chekoutlet Id ******************************/

            $outletDetails = $mysqlClass->mysqlQuery("SELECT outletid FROM `outlet_kyc_bankit` WHERE `user_id`='" . $USER_ID . "' ")->fetch(PDO::FETCH_ASSOC);

            $outletid = $outletDetails['outletid'];

            /******************* Chekoutlet Id ******************************/
            if ($outletid == '') {

                $request_param_2 = array(

                    'api_access_key' => $api_access_key,
                    'first_name' => $post['name'],
                    'middle_name' => $post['m_name'],
                    'last_name' => $post['l_name'],
                    'pan_no' => $post['pan_no'],
                    'dob' => $dob,
                    'email' => $post['email'],
                    'mobile' => $post['mobile'],
                    'address' => $post['address'],
                    'local_address' => $post['landmark'],
                    'city' => $cityName,
                    'district' => $cityName,
                    'state' => $stateName,
                    'pincode' => $post['pin'],
                    'company' => $post['cname'],
                    'shop_name' => $post['cname'],
                    'shop_address' => $post['c_address'],
                    'local_area' => $post['c_landmark'],
                    'shop_state' => $stateName_c,
                    'shop_city' => $cityName_c,
                    'shop_district' => $cityName_c,
                    'shop_in_code' => $post['c_pin'],
                    'shop_area' => $post['c_address'],
                    'alter_mobile' => $post['mobile'],
                    'pan_doc_name' => $post['pan_file_name'],
                    'aadhaar_no' => $post['aadhar_no'],
                    'aadhaar_doc_name' => $aadhar_file_name,
                    'shop_doc_name' => $shop_file_name,
                    'local_district' => $cityName,
                    'local_state' => $stateName,
                    'local_city' => $cityName,
                    'local_pin' => $post['pin'],
                    'area' => $cityName,

                );

                $outlet_json_2 = $helpers->netpaisa_curl($common_aeps_registration, $request_param_2);

                $outlet_result_2 = json_decode($outlet_json_2, true);

                if ($outlet_result_2['ERR_STATE'] == 0 && isset($outlet_result_2['outlet_id']) && $outlet_result_2['outlet_id'] != "") {
                    $target_dir = "https://www.digifintel.in/nps/apiUser/pan_img/";

                    $aadhaar_doc_name = $target_dir . $outlet_result_2['aadhaar_doc_name'];
                    $pan_doc_name = $target_dir . $outlet_result_2['pan_doc_name'];

                    $valueOutlet = array(
                        'user_id' => $USER_ID,
                        'outletid' => $outlet_result_2['outlet_id'],
                        'first_name' => $post['name'],
                        'middle_name' => $post['m_name'],
                        'last_name' => $post['l_name'],
                        'email' => $post['email'],
                        'mobile' => $post['mobile'],
                        'company' => $post['cname'],
                        'address' => $post['c_address'],
                        'pincode' => $post['c_pin'],
                        'city' => $cityName_c,
                        'state' => $stateName_c,
                        'district' => $cityName_c,
                        'pan_no' => $post['pan_no'],
                        'aadhaar' => $post['aadhar_no'],
                        'aadhaarimg' => $aadhaar_doc_name,
                        'panimg' => $pan_doc_name,
                        'dob' => $dob,
                        'registration_date' => date("Y-m-d H:i:s"),
                        'update_date' => date("Y-m-d H:i:s"),
                        'outlet_status' => 'PENDING',
                        'outlet_kyc' => 'PENDING',
                        'status' => 'SUCCESS',
                        'comments' => '',
                    );

                    $aeps_response_2 = $mysqlClass->insertData('outlet_kyc_bankit', $valueOutlet);

                } else {
                    $kycerror_2 = "AEPS 2 KYC " . $outlet_result_2['MSG'];
                }

            } else {

                $request_param_2 = array(

                    'outlet_id' => $outletid,
                    'api_access_key' => $api_access_key,
                    'first_name' => $post['name'],
                    'middle_name' => $post['m_name'],
                    'last_name' => $post['l_name'],
                    'pan_no' => $post['pan_no'],
                    'dob' => $dob,
                    'email' => $post['email'],
                    'mobile' => $post['mobile'],
                    'address' => $post['address'],
                    'local_address' => $post['landmark'],
                    'city' => $cityName,
                    'district' => $cityName,
                    'state' => $stateName,
                    'pincode' => $post['pin'],
                    'company' => $post['cname'],
                    'shop_name' => $post['cname'],
                    'shop_address' => $post['c_address'],
                    'local_area' => $post['c_landmark'],
                    'shop_state' => $post['state_name_c'],
                    'shop_city' => $post['city_name_c'],
                    'shop_district' => $post['city_name_c'],
                    'shop_in_code' => $post['c_pin'],
                    'shop_area' => $post['c_address'],
                    'alter_mobile' => $post['mobile'],
                    'pan_doc_name' => $pan_file_name,
                    'aadhaar_no' => $post['aadhar_no'],
                    'aadhaar_doc_name' => $aadhar_file_name,
                    'shop_doc_name' => $shop_file_name,
                    'local_district' => $cityName,
                    'local_state' => $stateName,
                    'local_city' => $cityName,
                    'local_pin' => $post['pin'],
                    'area' => $cityName,

                );

                $outlet_json_2 = $helpers->netpaisa_curl($common_bankit_kyc_update, $request_param_2);

                $outlet_result_2 = json_decode($outlet_json_2, true);

                if ($outlet_result_2['ERR_STATE'] == 0 && isset($outlet_result_2['outlet_id']) && $outlet_result_2['outlet_id'] != "") {
                    $target_dir = "https://www.digifintel.in/nps/apiUser/pan_img/";

                    $aadhaar_doc_name = $target_dir . $outlet_result_2['aadhaar_doc_name'];
                    $pan_doc_name = $target_dir . $outlet_result_2['pan_doc_name'];

                    $detailsvalue = array(
                        'first_name' => $post['name'],
                        'middle_name' => $post['m_name'],
                        'last_name' => $post['l_name'],
                        'email' => $post['email'],
                        'mobile' => $post['mobile'],
                        'company' => $post['cname'],
                        'address' => $post['c_address'],
                        'pincode' => $post['c_pin'],
                        'city' => $cityName,
                        'district' => $cityName,
                        'state' => $stateName,
                        'pan_no' => $post['pan_no'],
                        'aadhaar' => $post['aadhar_no'],
                        'aadhaarimg' => $aadhaar_doc_name,
                        'panimg' => $pan_doc_name,
                        'dob' => $dob,
                        'registration_date' => date("Y-m-d H:i:s"),
                        'update_date' => date("Y-m-d H:i:s"),
                        'outlet_status' => 'PENDING',
                        'outlet_kyc' => 'PENDING',
                        'status' => 'SUCCESS',
                    );

                    $updatedetails = $mysqlClass->updateData('outlet_kyc_bankit ', $detailsvalue, " where user_id = '" . $USER_ID . "' and outletid = '" . $outletid . "' ");

                } else {
                    $kycerror_2 = "AEPS 2 KYC " . $outlet_result_2['MSG'];
                }

            }

        }

        /********* AEPS 2 kyc registration End ***********/

        $response['ERROR_CODE'] = 0;

        $response['MESSAGE'][] = array("msg_1" => 'Update Profile Done');

        if (isset($kycerror)) {

            $response['MESSAGE'][] = array("msg_2" => $kycerror);

        } else {
            $response['MESSAGE'][] = array("msg_2" => "");
        }

        if (isset($kycerror_2)) {

            $response['MESSAGE'][] = array("msg_3" => $kycerror_2);

        } else {
            $response['MESSAGE'][] = array("msg_3" => "");
        }

    } else {

        $response['ERROR_CODE'] = 1;
        $response['MESSAGE'][] = array("msg_1" => 'Please enter valid email or mobile or PAN No or Aadhar No');
        $response['MESSAGE'][] = array("msg_2" => "");
        $response['MESSAGE'][] = array("msg_3" => "");
    }

} else {

    $response['ERROR_CODE'] = 1;
    $response['MESSAGE'][] = array("msg_1" => 'Invalid request !');
    $response['MESSAGE'][] = array("msg_2" => "");
    $response['MESSAGE'][] = array("msg_3" => "");
}
echo json_encode($response);

$mysqlClass->close_connection();
die();
