<?php

require("../../config.php");
require("../classes/db_class.php");
require("../classes/user_class.php");
require("../classes/comman_class.php");
require("../classes/jwt_encode_decode.php");
require("../classes/utility/Otp.php");
require("../classes/CustomerOtp.php");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require '../vendor/autoload.php';
$userObj = new User_class();
$helpers = new Helper_class();
$mysqlObj = new mysql_class();
$jwtED = new jwt_encode_decode();
$custOtp = new CustomerOtp();

date_default_timezone_set('Asia/Kolkata');

// ini_set('display_errors', 1);

// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);	


//  if( empty($headers_data['Appversion']) ){
// 	if($_SERVER['HTTP_X_API_KEY']==HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY']==DGFNAPASSKEY){	
// 	} else {
// 		$helpers->errorResponse("Authorization Invalid !");
// 	}
//  }

//echo "lat : ".$_POST['geo_location_lat'];

if (!isset($_POST['domain'])) {
	$helpers->errorResponse("Invalid Domain");
}
if (!isset($_POST['geo_location_lat'])) {
	$helpers->errorResponse("Invalid Geo Location");
	//$_POST['geo_location_lat'] = "";
}
if (!isset($_POST['geo_location_long'])) {
	$helpers->errorResponse("Invalid Geo Location");
	//$_POST['geo_location_long'] = "";
}
if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST)) {
	$post = $helpers->clearSlashes($_POST);

	//echo "<pre>";print_r($post);echo "</pre>";
	if ($post['login'] == "mobile") {
		$user_ip = $_SERVER['REMOTE_ADDR'];
		$server = $_SERVER;
	}

	/*Block IPs and Latitude and Longitude*/
	$blockIps = array('185.185.133.180', '185.185.133.189', '106.195.79.28', '106.208.39.75', '185.54.231.18', '185.54.231.42', '185.54.231.52', '5.62.34.10', '5.62.34.11', '5.62.34.9', '5.62.34.14', '106.207.138.117', '106.207.181.238');

	if (in_array($user_ip, $blockIps)) {
		$helpers->errorResponse('Please try again.');
	} else {
	}

	$geoLatVal = number_format((float) ($_POST['geo_location_lat']), 2, '.', '');
	$geoLongVal = number_format((float) ($_POST['geo_location_long']), 2, '.', '');

	if (($geoLatVal >= 12.95) && ($geoLatVal <= 12.979) && ($geoLatVal >= 12.99) && ($geoLatVal <= 13.00) && ($geoLongVal >= 77.50) && ($geoLongVal <= 77.65)) {
		$helpers->errorResponse("Try after some time.");
	}



	if ( /*isset($post['pin']) && */isset($post['mobile_number'])) {

		$mobile_number = $post['mobile_number'];
		$hash_pin_arr = $helpers->hashPin($post['pin']);
		$hash_pin = $hash_pin_arr['encrypted'];

		$domainDetail = $mysqlObj->mysqlQuery(" select user_id from add_white_label where domain = '" . $post['domain'] . "' ");
		$resWLID = $domainDetail->fetch(PDO::FETCH_ASSOC);
		if (!isset($resWLID['user_id']) || empty($resWLID['user_id'])) {
			$helpers->errorResponse("Domain not whitelisted");
		} else {
			$CheckLoginWithMobile = $mysqlObj->fetchRow("`add_cust`", " user ", " where `mobile`='" . $mobile_number . "' and wl_id = '" . $resWLID['user_id'] . "' and status = 'ENABLED' ");

			if (isset($CheckLoginWithMobile['user']) && !empty($CheckLoginWithMobile['user'])) {
				$username = $CheckLoginWithMobile['user'];
				$post['userid'] = $CheckLoginWithMobile['user'];
			} else {
				$helpers->errorResponse("Mobile number not found. Please login with registered mobile number only!");
			}
		}
		$CheckUserDisabled = $mysqlObj->fetchRow("`add_cust`", " id ", " where (`user`='" . $username . "' OR `user`='" . $post['userid'] . "') and `login_blocked` = 1 ");
		if ($CheckUserDisabled == 0) {

			$user = $mysqlObj->fetchRow("`add_cust`", " otp_on_sms,otp_on_email,`user`,usertype, `pass`,`security_pin`,`id`,`name`, `email`, `mobile`,  `service_access`,`netpaisa_services`,`wl_id`,`admin_id`,
				`creator_id`", " where (`user`='" . $username . "' OR `user`='" . $post['userid'] . "') and `status` = 'ENABLED' ");

			$wlDetail = $mysqlObj->mysqlQuery(" select a.otp_on_sms,a.otp_on_email,b.domain,b.user_id from add_cust as a, add_white_label as b where a.id = b.user_id and a.status = 'ENABLED' and a.id = '" . $user['wl_id'] . "'  ");
			$resWL = $wlDetail->fetch(PDO::FETCH_ASSOC);

			$isOtp = 1;
			$response['otp_already_active'] = 0;

			if ($user['user'] == $username || $user['user'] == $post['userid']) {

				if (empty($resWL['user_id'])) {
					$helpers->errorResponse("Admin is Disabled.");
				}
				if (isset($resWL)) {

					/* store some app details*/
					if ($post['login'] == "mobile") {

						$getUserAppDetails = $mysqlObj->mysqlQuery(" SELECT id,device_id FROM user_default_app_details WHERE user_id='" . $user['id'] . "' ");
						$getUserAppData = $getUserAppDetails->fetch(PDO::FETCH_ASSOC);
						if (isset($getUserAppData) && $getUserAppData['id'] > 0) {
							$deviceId = explode(',', $getUserAppData['device_id']);
							if (in_array($post['device_id'], $deviceId, TRUE)) {
							} else {
								if (empty($deviceId[0]) || $deviceId[0] == null || $deviceId[0] == '') {
									$appData = array(
										'mac_id' => $post['mac_id'],
										'device_id' => $post['device_id'],
										'imei_id' => $post['imei_id'],
										'device_name' => $post['device_name'],
										'device_model' => $post['device_model'],
										'geo_location_lat' => $post['geo_location_lat'],
										'geo_location_long' => $post['geo_location_long'],
										'device_version' => $post['device_version'],
										'login_device' => $post['login_device']
									);
									$mysqlObj->updateData("user_default_app_details", $appData, " where user_id='" . $user['id'] . "' ");
								} else {
									// we have temporily comment duplicate device as of now... will open it once all get settled well
									//$helpers->errorResponse("You have already registered with other device!");
								}
							}
						} else {
							$appData = array(
								'user_id' => $user['id'],
								'login_type' => $post['login'],
								'mac_id' => $post['mac_id'],
								'device_id' => $post['device_id'],
								'imei_id' => $post['imei_id'],
								'device_name' => $post['device_name'],
								'device_model' => $post['device_model'],
								'installation_mode' => $post['installation_mode'],
								'geo_location_lat' => $post['geo_location_lat'],
								'geo_location_long' => $post['geo_location_long'],
								'device_version' => $post['device_version'],
								'login_device' => $post['login_device'],
								'checksum' => $post['checksum'],
								'created_date' => date("Y-m-d H:i:s"),
								'wl_id' => $user['wl_id']
							);
							$mysqlObj->insertData("`user_default_app_details`", $appData);
						}

						//                    if(isset($post['login_app']) && $post['login_app'] == "B2C")
						//                    {
						//                        if(isset($post['login_service_mode']) && ( $post['login_service_mode'] == "BANKING" || $post['login_service_mode'] == "FINANCIAL"))
						//                        { 
						// $dt = array("login_service_mode"=>$post['login_service_mode']);
						//                            $mysqlObj->updateData("cust_details",$dt," where user_id='".$user['id']."' ");
						//                        }
						//                    }
					}


					$OtpActiveOnSms = 0;
					$OtpActiveOnEmail = 0;

					if ($user['otp_on_sms'] == 1) {
						$OtpActiveOnSms = 1;
					}
					if ($user['otp_on_email'] == 1) {
						$OtpActiveOnEmail = 1;
					}

					if ($OtpActiveOnSms == 0 && $OtpActiveOnEmail == 0) { // PIN BASED						

						if (empty($resWL['user_id'])) {
							$helpers->errorResponse("Admin is Disabled.");
						} else if (isset($resWL) && $resWL['user_id'] == $user['wl_id']) {
							$response['ERROR_CODE'] = 0;
							$response['MESSAGE'] = "UserId and Password Valid.";
							$response['DOMAIN'] = $resWL['domain'];
							$response['IS_OTP_REQUIRED'] = 0;
							$response['next_page'] = "verify_pin";
							//$response['next_page'] = "verify_otp";
							$auth_token = $AuthChecksum->CreateWebServiceOAuthToken($user['id'], $device_id, $source);
							$response['auth_token'] = $auth_token;
							$response['LOGIN_USER_ID'] = $user['id'];
						} else {
							$helpers->errorResponse("Invalid Domain.");
						}

					} else if ($OtpActiveOnSms == 1 || $OtpActiveOnEmail == 1) { // OTP BASED					
						$CheckIfOtpActive = $custOtp->IsLastOtpIsActive($user['id'], $user_ip);

						if ($CheckIfOtpActive === false) {

							// Need OTP, before redirecting to dashboard
							$otp = Otp::generateOtp(OTP_LENGTH);
							if (isset($post['login_app']) && $post['login_app'] == "B2C") {
							} else {
								if ($OtpActiveOnEmail == 1) {
									$EmailSentResponse = SendOtpOnEmail($user, $resWL, $otp);
								}
								if ($OtpActiveOnSms == 1) {
									$SMSSentResponse = SendOtpOnSms($user, $otp);
								}
							}

							if ($SMSSentResponse === true || $EmailSentResponse === true) {

								$hash_otp = crypt($otp);
								$customer_data = array(
									"user_id" => $user['id'],
									"mobile_number" => $user['mobile'],
									"otp" => $hash_otp,
									"is_invoked" => 0,
									"is_expired" => 0,
									"user_ip" => $user_ip
								);

								$custOtpId = $custOtp->saveOtp('customer_otps', $customer_data);
							}


							$response['otp_already_active'] = 0;

						} else {
							$response['otp_already_active'] = 1;
						}

						$response['ERROR_CODE'] = 0;
						$response['MESSAGE'] = "UserId and Password Valid.";
						$response['DOMAIN'] = $resWL['domain'];
						$response['USER_EMAIL'] = $user['email'];
						$response['USER_MOBILE'] = $user['mobile'];
						$response['LOGIN_USER_ID'] = $user['id'];
						if (isset($post['login_app']) && $post['login_app'] == "B2C") {
							$response['IS_OTP_REQUIRED'] = 0;
							//$response['next_page'] = "verify_pin";
							$response['next_page'] = "verify_otp";
						} else {
							$response['IS_OTP_REQUIRED'] = 1;
							$response['next_page'] = "verify_otp";
						}

						$auth_token = $AuthChecksum->CreateWebServiceOAuthToken($user['id'], $device_id, $source);
						$response['auth_token'] = $auth_token;

					} else {
						$helpers->errorResponse("No medium to authentication.");
					}
				} else {
					$helpers->errorResponse("Invalid User.");
				}
			} else {
				$helpers->errorResponse("Invalid mobile number.");
			}
		} else {
			$helpers->errorResponse("Your account has been blocked.Please contact administrator.");
		}
	} else {
		$helpers->errorResponse("Mobile number empty.");
	}

} else {
	$helpers->errorResponse("Invalid request !");
}
echo json_encode($response);


function SendOtpOnSms($user, $otp)
{

	global $custOtp;
	global $mysqlObj;

	//$message = "One Tme Password(otp) is {$otp}";

	if ($user['wl_id'] == '39428') { /* otp for ekendra (dipesh)*/
		$message = "Ekendra never calls you for asking OTP and Login credentials Please do not share this with anyone Your confidential verification code is {$otp}";
	} else if ($user['wl_id'] == '72169') /*otp for aonepay(abubakar)*/{
		$message = "Your OTP is {$otp} for login Don't Disclose it anyone Team Aonepay";
	} else if ($user['wl_id'] == '73229') /*otp for(Sudipta Dutta)*/{
		$message = "Your OTP is {$otp} for login Don't Disclose it anyone. Thanks Wallet Pe Services";
	} else {
		$message = "Your OTP is {$otp} Don't Disclose it anyone";
	}

	if ($user['wl_id'] == '39428' || $user['wl_id'] == '72169') {
		$SmsResponse = $mysqlObj->SendDynamicMessageWithTemplate($user['mobile'], $message, $user['wl_id'], $user['admin_id'], 'login');
	} else {
		$SmsResponse = $mysqlObj->SendDynamicMessage($user['mobile'], $message, $user['wl_id'], $user['admin_id']);
	}
	//$SmsResponse = $mysqlObj->SendDynamicMessage( $user['mobile'],$message,$user['wl_id'],$user['admin_id'] );
	$ArraySmsResponse = json_decode($SmsResponse, true);

	if (strcasecmp($ArraySmsResponse['status'], "OK") !== false || !empty($ArraySmsResponse)) {

		return true;
	} else {
		return false;
	}


}

function SendOtpOnEmail($user, $resWL, $otp)
{
	global $mysqlObj;


	$WLdomain = $resWL['domain'];


	$domain = str_replace("https://", "", $WLdomain);
	$domain = rtrim($domain, "/");

	$WLdomain = $mysqlObj->getDomain($WLdomain);
	$ToEmail = $user['email'];


	$MailTitle = "One Time Password";

	$subject = "{$domain} One Time Password";

	$OtpExpTime = $mysqlObj->GetOtpExpTimeAndWrongAttempt();
	$otp_exp_time = $OtpExpTime["otp_exp_time"];

	$email_body = "<p>Dear Customer,<br></p>
					<p>The One Time Password (OTP) for your {$domain} panel to authenticate your device/ browser for a secured website login is " . $otp . ". The OTP is valid for {$otp_exp_time} mins or one successful attempt, whichever is earlier. Please do not share with anyone.<br><br><br></p>
					<p><strong>Warm Regards,</strong><br>{$domain}<p>
					";
	$EmailRsp = $mysqlObj->SendDynamicMessageOnEmail($ToEmail, $WLdomain, $MailTitle, $subject, $email_body);
	//var_dump($EmailRsp);exit;
	return $EmailRsp;
}



$mysqlObj->close_connection();
die();
