<?php
require("../config.php");
require("classes/db_class.php");
require("classes/comman_class.php");
require("classes/user_class.php");
require("classes/common/Common.php");
require("classes/jwt_encode_decode.php");

$helpers = new Helper_class();
$commonfunction = new Common();
$mysqlClass = new Mysql_class();
$userClass = new User_class();
$jwtED = new jwt_encode_decode();

function requiredInput($inputArr, $requiredFields)
{
    $emptyError = array();
    foreach ($requiredFields as $v) {
        if (!isset($inputArr[$v]) || empty($inputArr[$v])) {
            $emptyError[] = $v;
        }
    }
    return $emptyError;
}
if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST)) {
    $post = $helpers->clearSlashes($_POST);
    $requiredFields = array('mobile', 'otp');
    $errorRequired = requiredInput($post, $requiredFields);
    if (!empty($errorRequired)) {
        foreach ($errorRequired as $eE) {
            $helpers->errorResponse("Please enter valid " . $eE);
        }
    }
    $otp = $post['otp'];
    $user_id = $post['user_id'];
    $mobile = $post['mobile'];

    if (!preg_match('/^[0-9]{10}+$/', $mobile)) {
        $helpers->errorResponse('Please enter valid mobile..');
    }
    $current_time = date('Y-m-d H:i:s', time());
    $previous_time = date('Y-m-d H:i:s', strtotime("-3 min"));

    $checkOtp = $mysqlClass->fetchRow("customer_otps", " otp ", " WHERE mobile_number = '" . $mobile . "' and otp = '" . $otp . "' and is_expired = '0' and created_at between '" . $previous_time . "' and '" . $current_time . "' and user_id ='" . $user_id . "' ");
   
    if (isset($checkOtp['otp']) && $checkOtp['otp'] == $otp) {

        $dValuesOt = array(
            'is_invoked'=>1,
            'is_expired' => 1,
            'updated_at' => $current_time
        );
        $mysqlClass->updateData(' customer_otps ', $dValuesOt, " WHERE mobile_number = '" . $mobile . "' and otp = '" . $otp . "' and is_expired = '0' and created_at between '" . $previous_time . "' and '" . $current_time . "' and user_id ='" . $user_id . "' ");
        $response['ERROR_CODE'] = 0;
        $response['MESSAGE'] = 'The Activation key verified successfully.';
    } else {

        $helpers->errorResponse('Please enter valid otp.');
    }

    /////////////////// End //////////////////

} else {
    $response['ERROR_CODE'] = 1;
    $response['MESSAGE'] = 'Invalid request !';
}
echo json_encode($response);
$mysqlClass->close_connection();
die();
