<?php if (!empty($userDetails['social_links'])) {
	$social = json_decode($userDetails['social_links'], true);
}
if(!isset($_SESSION)) { session_start(); }
$token = $_SESSION['token_csrf'];
?>
<form method="post" name="agent-bank-details" id="agent-bank-details">
	<input type="hidden" name="token__csrf" id="token__csrf" value="<?php echo hash_hmac('sha256', 'agent-bank-details', $token); ?>" />
	<input type="hidden" name="uaction" id="uaction"  value="agent-bank-details" />
	<div class="card card-success">
		<div class="basic_detail_title">
			<h4>Bank information (for payout credit purpose)* Please fill the details as per Bank records</h4>
			<span class="title_hr"></span>
		</div>
		<div class="card-body">
			<div class="row form-group">
				<div class="col-lg-3 bank_name_select">
					<label>Bank Name<span>*</span></label>
					<select class="form-control select2" name="bank_name">
						<option value="">Select</option>
						<?php foreach ($allBanksList as $blist) { ?>
							<option <?php echo !empty($userDetails["bank_name"]) && $blist['id'] == $userDetails["bank_name"] ? "selected" : ""; ?> value="<?= $blist['id'] ?>"><?= $blist['name'] ?></option>
						<?php } ?>
						<option <?php echo !empty($userDetails["bank_name"]) && $userDetails["bank_name"] == "-1" ? "selected" : ""; ?> value="-1">Other</option>
					</select>
				</div>
				<div class="col-lg-3">
					<label>Account Holder Name<span>*</span></label>
					<input placeholder="Enter account holder name" type="text" class="form-control required" name="ac_holder_name" onKeyDown="return validateString(event)" id="" value="<?php echo $userDetails["ac_holder_name"] ?? null; ?>">
				</div>
				<div class="col-lg-3">
					<label>Account Number<span>*</span></label>
					<input placeholder="Enter account number" type="text" class="form-control required" onKeyDown="return isNumber(event)" name="ac_no" id="" value="<?php echo $userDetails["ac_no"] ?? null; ?>" maxlength="18">
				</div>
				<div class="col-lg-3">
					<label>NEFT IFSC Code<span>*</span></label>
					<input placeholder="Enter neft ifsc code" type="text" class="form-control required" maxlength="11" name="ifsc_code" id="" value="<?php echo $userDetails["ifsc_code"] ?? null; ?>">
					<div id="ifsc_err"></div>
				</div>
			</div>

			<!-- <div class="row form-group">
								<div class="col-lg-3">
									<label>Pincode<span>*</span></label>
									<input placeholder="Enter pincode" type="text" class="form-control required" name="pincode" id="">
								</div>
								<div class="col-lg-3">
									<label>Branch State<span>*</span></label>
									<input placeholder="Enter branch state" type="text" class="form-control required" name="branch state" id="">
								</div>
								<div class="col-lg-3">
									<label>Branch City<span>*</span></label>
									<input placeholder="Enter branch city" type="text" class="form-control required" name="branch city" id="">
								</div>
								<div class="col-lg-3">
									<label>Branch Address<span>*</span></label>
									<input placeholder="Enter branch address" type="text" class="form-control required" name="branch add" id="">
								</div>
							</div>							 -->
		</div>
	</div>

	<div class="card card-success">
		<div class="basic_detail_title">
			<h4>Social Media</h4>
			<span class="title_hr"></span>
		</div>
		<div class="card-body">
			<div class="row form-group">
				<div class="col-lg-4">
					<label>Facebook</label>
					<input placeholder="Enter Url" type="text" class="form-control required" name="facebook" value="<?php echo $social["facebook"] ?? null; ?>">
				</div>
				<div class="col-lg-4">
					<label>Instagram</label>
					<input placeholder="Enter Url" type="text" class="form-control required" name="instagram" value="<?php echo $social["instagram"] ?? null; ?>">
				</div>
				<div class="col-lg-4">
					<label>Linkedin</label>
					<input placeholder="Enter Url" type="text" class="form-control required" name="linkedin" value="<?php echo $social["linkedin"] ?? null; ?>">
				</div>
			</div>
			<div class="row form-group">
				<div class="col-lg-4">
					<label>Twitter</label>
					<input placeholder="Enter Url" type="text" class="form-control required" name="twitter" value="<?php echo $social["twitter"] ?? null; ?>">
				</div>
				<div class="col-lg-4">
					<label>Telegram</label>
					<input placeholder="Enter Url" type="text" class="form-control required" name="telegram" value="<?php echo $social["telegram"] ?? null; ?>">
				</div>
			</div>
		</div>
	</div>
	<div class="frmmsg" align="center"></div>
	<div class="previos_nxt">
		<a href="agent_profile.php?ref=<?php echo $_GET['ref']; ?>&step=basic-details" class="prev" id="stepFour_prev">Previous</a>
		<a href="javascript:void(0)" class="nxt" id="stepTwo_nxt">Save & Continue</a>
	</div>
	</div>
</form>